/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.junit;

import junit.framework.TestCase;
import org.jfree.data.DataUtilities;
import org.jfree.data.DefaultKeyedValues2D;

public class DataUtilitiesTests
extends TestCase {
    private static final double EPSILON = 1.0E-9;

    public void testCreateNumberArray2D() {
        double[][] dArrayArray = new double[][]{{1.1, 2.2, 3.3, 4.4}, {1.1, 2.2, 3.3, 4.4, 5.5}};
        Number[][] numberArray = DataUtilities.createNumberArray2D(dArrayArray);
        DataUtilitiesTests.assertEquals((int)2, (int)numberArray.length);
        DataUtilitiesTests.assertEquals((int)4, (int)numberArray[0].length);
        DataUtilitiesTests.assertEquals((int)5, (int)numberArray[1].length);
    }

    public void testCalculateColumnTotal() {
        DefaultKeyedValues2D defaultKeyedValues2D = new DefaultKeyedValues2D();
        defaultKeyedValues2D.addValue(new Double(1.0), (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        defaultKeyedValues2D.addValue(new Double(2.0), (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        defaultKeyedValues2D.addValue(new Double(3.0), (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        defaultKeyedValues2D.addValue(new Double(4.0), (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DataUtilitiesTests.assertEquals((double)4.0, (double)DataUtilities.calculateColumnTotal(defaultKeyedValues2D, 0), (double)1.0E-9);
        DataUtilitiesTests.assertEquals((double)6.0, (double)DataUtilities.calculateColumnTotal(defaultKeyedValues2D, 1), (double)1.0E-9);
        defaultKeyedValues2D.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DataUtilitiesTests.assertEquals((double)2.0, (double)DataUtilities.calculateColumnTotal(defaultKeyedValues2D, 1), (double)1.0E-9);
    }

    public void testCalculateRowTotal() {
        DefaultKeyedValues2D defaultKeyedValues2D = new DefaultKeyedValues2D();
        defaultKeyedValues2D.addValue(new Double(1.0), (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        defaultKeyedValues2D.addValue(new Double(2.0), (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        defaultKeyedValues2D.addValue(new Double(3.0), (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        defaultKeyedValues2D.addValue(new Double(4.0), (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DataUtilitiesTests.assertEquals((double)3.0, (double)DataUtilities.calculateRowTotal(defaultKeyedValues2D, 0), (double)1.0E-9);
        DataUtilitiesTests.assertEquals((double)7.0, (double)DataUtilities.calculateRowTotal(defaultKeyedValues2D, 1), (double)1.0E-9);
        defaultKeyedValues2D.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DataUtilitiesTests.assertEquals((double)3.0, (double)DataUtilities.calculateRowTotal(defaultKeyedValues2D, 1), (double)1.0E-9);
    }
}

