/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.jdbc;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import org.jfree.data.general.DefaultPieDataset;

public class JDBCPieDataset
extends DefaultPieDataset {
    private transient Connection connection;

    public JDBCPieDataset(String string, String string2, String string3, String string4) throws SQLException, ClassNotFoundException {
        Class.forName(string2);
        this.connection = DriverManager.getConnection(string, string3, string4);
    }

    public JDBCPieDataset(Connection connection) {
        if (connection == null) {
            throw new NullPointerException("A connection must be supplied.");
        }
        this.connection = connection;
    }

    public JDBCPieDataset(Connection connection, String string) throws SQLException {
        this(connection);
        this.executeQuery(string);
    }

    public void executeQuery(String string) throws SQLException {
        this.executeQuery(this.connection, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeQuery(Connection connection, String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n = resultSetMetaData.getColumnCount();
            if (n != 2) {
                throw new SQLException("Invalid sql generated.  PieDataSet requires 2 columns only");
            }
            int n2 = resultSetMetaData.getColumnType(2);
            double d = Double.NaN;
            block15: while (resultSet.next()) {
                String string2 = resultSet.getString(1);
                switch (n2) {
                    case -5: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 6: 
                    case 7: 
                    case 8: {
                        d = resultSet.getDouble(2);
                        this.setValue((Comparable)((Object)string2), d);
                        continue block15;
                    }
                    case 91: 
                    case 92: 
                    case 93: {
                        Timestamp timestamp = resultSet.getTimestamp(2);
                        d = timestamp.getTime();
                        this.setValue((Comparable)((Object)string2), d);
                        continue block15;
                    }
                }
                System.err.println("JDBCPieDataset - unknown data type");
            }
            this.fireDatasetChanged();
        }
        finally {
            if (resultSet != null) {
                try {
                    resultSet.close();
                }
                catch (Exception exception) {
                    System.err.println("JDBCPieDataset: swallowing exception.");
                }
            }
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (Exception exception) {
                    System.err.println("JDBCPieDataset: swallowing exception.");
                }
            }
        }
    }

    public void close() {
        try {
            this.connection.close();
        }
        catch (Exception exception) {
            System.err.println("JdbcXYDataset: swallowing exception.");
        }
    }
}

