/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.general.DefaultKeyedValuesDataset;
import org.jfree.data.general.KeyedValuesDataset;

public class DefaultKeyedValuesDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultKeyedValuesDatasetTests.class);
    }

    public DefaultKeyedValuesDatasetTests(String string) {
        super(string);
    }

    public void testCloning() {
        DefaultKeyedValuesDataset defaultKeyedValuesDataset = new DefaultKeyedValuesDataset();
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"V1"), new Integer(1));
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"V2"), null);
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"V3"), new Integer(3));
        DefaultKeyedValuesDataset defaultKeyedValuesDataset2 = null;
        try {
            defaultKeyedValuesDataset2 = (DefaultKeyedValuesDataset)defaultKeyedValuesDataset.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        DefaultKeyedValuesDatasetTests.assertTrue((defaultKeyedValuesDataset != defaultKeyedValuesDataset2 ? 1 : 0) != 0);
        DefaultKeyedValuesDatasetTests.assertTrue((defaultKeyedValuesDataset.getClass() == defaultKeyedValuesDataset2.getClass() ? 1 : 0) != 0);
        DefaultKeyedValuesDatasetTests.assertTrue((boolean)defaultKeyedValuesDataset.equals(defaultKeyedValuesDataset2));
    }

    public void testSerialization() {
        DefaultKeyedValuesDataset defaultKeyedValuesDataset = new DefaultKeyedValuesDataset();
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"C1"), new Double(234.2));
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"C2"), null);
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"C3"), new Double(345.9));
        defaultKeyedValuesDataset.setValue((Comparable)((Object)"C4"), new Double(452.7));
        KeyedValuesDataset keyedValuesDataset = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultKeyedValuesDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            keyedValuesDataset = (KeyedValuesDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultKeyedValuesDatasetTests.assertEquals((Object)defaultKeyedValuesDataset, keyedValuesDataset);
    }
}

