/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general.junit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class DatasetUtilitiesTests
extends TestCase {
    private static final double EPSILON = 1.0E-10;

    public static Test suite() {
        return new TestSuite(DatasetUtilitiesTests.class);
    }

    public DatasetUtilitiesTests(String string) {
        super(string);
    }

    public void testJava() {
        DatasetUtilitiesTests.assertTrue((boolean)Double.isNaN(Math.min(1.0, Double.NaN)));
        DatasetUtilitiesTests.assertTrue((boolean)Double.isNaN(Math.max(1.0, Double.NaN)));
    }

    public void testCalculatePieDatasetTotal() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)DatasetUtilities.calculatePieDatasetTotal(defaultPieDataset), (double)1.0E-10);
        defaultPieDataset.setValue((Comparable)((Object)"A"), 1.0);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)DatasetUtilities.calculatePieDatasetTotal(defaultPieDataset), (double)1.0E-10);
        defaultPieDataset.setValue((Comparable)((Object)"B"), 3.0);
        DatasetUtilitiesTests.assertEquals((double)4.0, (double)DatasetUtilities.calculatePieDatasetTotal(defaultPieDataset), (double)1.0E-10);
    }

    public void testFindDomainBounds() {
        XYDataset xYDataset = this.createXYDataset1();
        Range range = DatasetUtilities.findDomainBounds(xYDataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)3.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateDomainBounds() {
        XYDataset xYDataset = this.createXYDataset1();
        Range range = DatasetUtilities.iterateDomainBounds(xYDataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)3.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testFindRangeBounds1() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        Range range = DatasetUtilities.findRangeBounds(categoryDataset);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)6.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testFindRangeBounds2() {
        XYDataset xYDataset = this.createXYDataset1();
        Range range = DatasetUtilities.findRangeBounds(xYDataset);
        DatasetUtilitiesTests.assertEquals((double)100.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)105.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateCategoryRangeBounds() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        Range range = DatasetUtilities.iterateCategoryRangeBounds(categoryDataset, false);
        DatasetUtilitiesTests.assertEquals((double)1.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)6.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testIterateXYRangeBounds() {
        XYDataset xYDataset = this.createXYDataset1();
        Range range = DatasetUtilities.iterateXYRangeBounds(xYDataset);
        DatasetUtilitiesTests.assertEquals((double)100.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)105.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testFindMinimumDomainValue() {
        XYDataset xYDataset = this.createXYDataset1();
        Number number = DatasetUtilities.findMinimumDomainValue(xYDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(1.0), (Object)number);
    }

    public void testFindMaximumDomainValue() {
        XYDataset xYDataset = this.createXYDataset1();
        Number number = DatasetUtilities.findMaximumDomainValue(xYDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(3.0), (Object)number);
    }

    public void testFindMinimumRangeValue() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        Number number = DatasetUtilities.findMinimumRangeValue(categoryDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(1.0), (Object)number);
        XYDataset xYDataset = this.createXYDataset1();
        Number number2 = DatasetUtilities.findMinimumRangeValue(xYDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(100.0), (Object)number2);
    }

    public void testFindMaximumRangeValue() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        Number number = DatasetUtilities.findMaximumRangeValue(categoryDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(6.0), (Object)number);
        XYDataset xYDataset = this.createXYDataset1();
        Number number2 = DatasetUtilities.findMaximumRangeValue(xYDataset);
        DatasetUtilitiesTests.assertEquals((Object)new Double(105.0), (Object)number2);
    }

    public void testMinMaxRange() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number number = DatasetUtilities.findMinimumRangeValue(defaultCategoryDataset);
        DatasetUtilitiesTests.assertTrue((number.doubleValue() < 100.1 ? 1 : 0) != 0);
        Number number2 = DatasetUtilities.findMaximumRangeValue(defaultCategoryDataset);
        DatasetUtilitiesTests.assertTrue((number2.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void test803660() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 1"));
        defaultCategoryDataset.addValue(101.1, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Type 2"));
        Number number = DatasetUtilities.findMaximumRangeValue(defaultCategoryDataset);
        DatasetUtilitiesTests.assertTrue((number.doubleValue() > 101.0 ? 1 : 0) != 0);
    }

    public void testCumulativeRange1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(10.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start"));
        defaultCategoryDataset.addValue(15.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        defaultCategoryDataset.addValue(-7.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        Range range = DatasetUtilities.findCumulativeRangeBounds(defaultCategoryDataset);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)range.getLowerBound(), (double)1.0E-8);
        DatasetUtilitiesTests.assertEquals((double)25.0, (double)range.getUpperBound(), (double)1.0E-8);
    }

    public void testCumulativeRange2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(-21.4, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Start Value"));
        defaultCategoryDataset.addValue(11.57, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 1"));
        defaultCategoryDataset.addValue(3.51, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 2"));
        defaultCategoryDataset.addValue(-12.36, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 3"));
        defaultCategoryDataset.addValue(3.39, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 4"));
        defaultCategoryDataset.addValue(38.68, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 5"));
        defaultCategoryDataset.addValue(-43.31, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 6"));
        defaultCategoryDataset.addValue(-29.59, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 7"));
        defaultCategoryDataset.addValue(35.3, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 8"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"Series 1"), (Comparable)((Object)"Delta 9"));
        Range range = DatasetUtilities.findCumulativeRangeBounds(defaultCategoryDataset);
        DatasetUtilitiesTests.assertEquals((double)-49.51, (double)range.getLowerBound(), (double)1.0E-8);
        DatasetUtilitiesTests.assertEquals((double)23.39, (double)range.getUpperBound(), (double)1.0E-8);
    }

    public void testCreateCategoryDataset1() {
        String[] stringArray = new String[]{"R1", "R2", "R3"};
        String[] stringArray2 = new String[]{"C1", "C2"};
        double[][] dArrayArray = new double[][]{{1.1, 1.2}, {2.1, 2.2}, {3.1, 3.2}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset((Comparable[])stringArray, (Comparable[])stringArray2, (double[][])dArrayArray);
        DatasetUtilitiesTests.assertTrue((categoryDataset.getRowCount() == 3 ? 1 : 0) != 0);
        DatasetUtilitiesTests.assertTrue((categoryDataset.getColumnCount() == 2 ? 1 : 0) != 0);
    }

    public void testCreateCategoryDataset2() {
        boolean bl = false;
        String[] stringArray = new String[]{"R1", "R2", "R3"};
        String[] stringArray2 = new String[]{"C1", "C2"};
        double[][] dArrayArray = new double[][]{{1.1, 1.2, 1.3}, {2.1, 2.2, 2.3}};
        CategoryDataset categoryDataset = null;
        try {
            categoryDataset = DatasetUtilities.createCategoryDataset((Comparable[])stringArray, (Comparable[])stringArray2, (double[][])dArrayArray);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            bl = true;
        }
        DatasetUtilitiesTests.assertTrue((boolean)bl);
        DatasetUtilitiesTests.assertTrue((categoryDataset == null ? 1 : 0) != 0);
    }

    public void testMaximumStackedRangeValue() {
        double d = 24.3;
        double d2 = 14.2;
        double d3 = 33.2;
        double d4 = 32.4;
        double d5 = 26.3;
        double d6 = 22.6;
        Double d7 = new Double(Math.max(d + d2 + d3, d4 + d5 + d6));
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(d, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 0"));
        defaultCategoryDataset.addValue(d2, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 0"));
        defaultCategoryDataset.addValue(d3, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 0"));
        defaultCategoryDataset.addValue(d4, (Comparable)((Object)"Row 0"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset.addValue(d5, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultCategoryDataset.addValue(d6, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        Number number = DatasetUtilities.findMaximumStackedRangeValue(defaultCategoryDataset);
        DatasetUtilitiesTests.assertTrue((boolean)number.equals(d7));
    }

    public void testFindStackedRangeBoundsForCategoryDataset1() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        Range range = DatasetUtilities.findStackedRangeBounds(categoryDataset);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)15.0, (double)range.getUpperBound(), (double)1.0E-10);
        categoryDataset = this.createCategoryDataset2();
        range = DatasetUtilities.findStackedRangeBounds(categoryDataset);
        DatasetUtilitiesTests.assertEquals((double)-2.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)2.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testFindStackedRangeBoundsForCategoryDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        Range range = DatasetUtilities.findStackedRangeBounds(defaultCategoryDataset);
        DatasetUtilitiesTests.assertTrue((range == null ? 1 : 0) != 0);
    }

    public void testFindStackedRangeBoundsForTableXYDataset1() {
        TableXYDataset tableXYDataset = this.createTableXYDataset1();
        Range range = DatasetUtilities.findStackedRangeBounds(tableXYDataset);
        DatasetUtilitiesTests.assertEquals((double)-2.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)2.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testFindStackedRangeBoundsForTableXYDataset2() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        Range range = DatasetUtilities.findStackedRangeBounds(defaultTableXYDataset);
        DatasetUtilitiesTests.assertEquals((Object)range, (Object)new Range(0.0, 0.0));
    }

    public void testStackedRangeWithMap() {
        CategoryDataset categoryDataset = this.createCategoryDataset1();
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"G0"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"R2"), (Comparable)((Object)"G1"));
        Range range = DatasetUtilities.findStackedRangeBounds(categoryDataset, keyToGroupMap);
        DatasetUtilitiesTests.assertEquals((double)0.0, (double)range.getLowerBound(), (double)1.0E-10);
        DatasetUtilitiesTests.assertEquals((double)9.0, (double)range.getUpperBound(), (double)1.0E-10);
    }

    public void testLimitPieDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        PieDataset pieDataset = DatasetUtilities.createConsolidatedPieDataset(defaultPieDataset, (Comparable)((Object)"Other"), 0.05);
        DatasetUtilitiesTests.assertEquals((int)0, (int)pieDataset.getItemCount());
        defaultPieDataset.setValue((Comparable)((Object)"Item 1"), 1.0);
        defaultPieDataset.setValue((Comparable)((Object)"Item 2"), 49.5);
        defaultPieDataset.setValue((Comparable)((Object)"Item 3"), 49.5);
        pieDataset = DatasetUtilities.createConsolidatedPieDataset(defaultPieDataset, (Comparable)((Object)"Other"), 0.05);
        DatasetUtilitiesTests.assertEquals((int)3, (int)pieDataset.getItemCount());
        DatasetUtilitiesTests.assertEquals((Object)"Item 1", (Object)pieDataset.getKey(0));
        DatasetUtilitiesTests.assertEquals((Object)"Item 2", (Object)pieDataset.getKey(1));
        DatasetUtilitiesTests.assertEquals((Object)"Item 3", (Object)pieDataset.getKey(2));
        defaultPieDataset.setValue((Comparable)((Object)"Item 4"), 1.0);
        pieDataset = DatasetUtilities.createConsolidatedPieDataset(defaultPieDataset, (Comparable)((Object)"Other"), 0.05, 2);
        DatasetUtilitiesTests.assertEquals((int)3, (int)pieDataset.getItemCount());
        DatasetUtilitiesTests.assertEquals((Object)"Item 2", (Object)pieDataset.getKey(0));
        DatasetUtilitiesTests.assertEquals((Object)"Item 3", (Object)pieDataset.getKey(1));
        DatasetUtilitiesTests.assertEquals((Object)"Other", (Object)pieDataset.getKey(2));
        DatasetUtilitiesTests.assertEquals((Object)new Double(2.0), (Object)pieDataset.getValue((Comparable)((Object)"Other")));
    }

    private CategoryDataset createCategoryDataset1() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        return defaultCategoryDataset;
    }

    private CategoryDataset createCategoryDataset2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(-2.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C0"));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"R0"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(-1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        return defaultCategoryDataset;
    }

    private XYDataset createXYDataset1() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"S1"));
        xYSeries.add(1.0, 100.0);
        xYSeries.add(2.0, 101.0);
        xYSeries.add(3.0, 102.0);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"S2"));
        xYSeries2.add(1.0, 103.0);
        xYSeries2.add(2.0, (Number)null);
        xYSeries2.add(3.0, 105.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        xYSeriesCollection.setIntervalWidth(0.0);
        return xYSeriesCollection;
    }

    private TableXYDataset createTableXYDataset1() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 1.0);
        xYSeries.add(2.0, 2.0);
        defaultTableXYDataset.addSeries(xYSeries);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"), true, false);
        xYSeries2.add(1.0, -2.0);
        xYSeries2.add(2.0, -1.0);
        defaultTableXYDataset.addSeries(xYSeries2);
        return defaultTableXYDataset;
    }
}

