/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import org.jfree.data.general.CombinationDataset;
import org.jfree.data.general.SeriesDataset;
import org.jfree.data.xy.AbstractIntervalXYDataset;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.SignalsDataset;
import org.jfree.data.xy.XYDataset;

public class SubSeriesDataset
extends AbstractIntervalXYDataset
implements OHLCDataset,
SignalsDataset,
IntervalXYDataset,
CombinationDataset {
    private SeriesDataset parent = null;
    private int[] map;

    public SubSeriesDataset(SeriesDataset seriesDataset, int[] nArray) {
        this.parent = seriesDataset;
        this.map = nArray;
    }

    public SubSeriesDataset(SeriesDataset seriesDataset, int n) {
        this(seriesDataset, new int[]{n});
    }

    public Number getHigh(int n, int n2) {
        return ((OHLCDataset)this.parent).getHigh(this.map[n], n2);
    }

    public double getHighValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getHigh(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getLow(int n, int n2) {
        return ((OHLCDataset)this.parent).getLow(this.map[n], n2);
    }

    public double getLowValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getLow(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getOpen(int n, int n2) {
        return ((OHLCDataset)this.parent).getOpen(this.map[n], n2);
    }

    public double getOpenValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getOpen(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getClose(int n, int n2) {
        return ((OHLCDataset)this.parent).getClose(this.map[n], n2);
    }

    public double getCloseValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getClose(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getVolume(int n, int n2) {
        return ((OHLCDataset)this.parent).getVolume(this.map[n], n2);
    }

    public double getVolumeValue(int n, int n2) {
        double d = Double.NaN;
        Number number = this.getVolume(n, n2);
        if (number != null) {
            d = number.doubleValue();
        }
        return d;
    }

    public Number getX(int n, int n2) {
        return ((XYDataset)this.parent).getX(this.map[n], n2);
    }

    public Number getY(int n, int n2) {
        return ((XYDataset)this.parent).getY(this.map[n], n2);
    }

    public int getItemCount(int n) {
        return ((XYDataset)this.parent).getItemCount(this.map[n]);
    }

    public int getSeriesCount() {
        return this.map.length;
    }

    public Comparable getSeriesKey(int n) {
        return this.parent.getSeriesKey(this.map[n]);
    }

    public Number getStartX(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartX(this.map[n], n2);
        }
        return this.getX(n, n2);
    }

    public Number getEndX(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndX(this.map[n], n2);
        }
        return this.getX(n, n2);
    }

    public Number getStartY(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getStartY(this.map[n], n2);
        }
        return this.getY(n, n2);
    }

    public Number getEndY(int n, int n2) {
        if (this.parent instanceof IntervalXYDataset) {
            return ((IntervalXYDataset)this.parent).getEndY(this.map[n], n2);
        }
        return this.getY(n, n2);
    }

    public int getType(int n, int n2) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getType(this.map[n], n2);
        }
        return this.getY(n, n2).intValue();
    }

    public double getLevel(int n, int n2) {
        if (this.parent instanceof SignalsDataset) {
            return ((SignalsDataset)this.parent).getLevel(this.map[n], n2);
        }
        return this.getYValue(n, n2);
    }

    public SeriesDataset getParent() {
        return this.parent;
    }

    public int[] getMap() {
        return (int[])this.map.clone();
    }
}

