/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.general;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.EventListener;
import java.util.List;
import javax.swing.event.EventListenerList;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.DatasetGroup;

public abstract class AbstractDataset
implements Dataset,
Cloneable,
Serializable,
ObjectInputValidation {
    private static final long serialVersionUID = 1918768939869230744L;
    private DatasetGroup group = new DatasetGroup();
    private transient EventListenerList listenerList = new EventListenerList();

    protected AbstractDataset() {
    }

    public DatasetGroup getGroup() {
        return this.group;
    }

    public void setGroup(DatasetGroup datasetGroup) {
        if (datasetGroup == null) {
            throw new IllegalArgumentException("Null 'group' argument.");
        }
        this.group = datasetGroup;
    }

    public void addChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.add(DatasetChangeListener.class, datasetChangeListener);
    }

    public void removeChangeListener(DatasetChangeListener datasetChangeListener) {
        this.listenerList.remove(DatasetChangeListener.class, datasetChangeListener);
    }

    public boolean hasListener(EventListener eventListener) {
        List<Object> list = Arrays.asList(this.listenerList.getListenerList());
        return list.contains(eventListener);
    }

    protected void fireDatasetChanged() {
        this.notifyListeners(new DatasetChangeEvent(this, this));
    }

    protected void notifyListeners(DatasetChangeEvent datasetChangeEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != DatasetChangeListener.class) continue;
            ((DatasetChangeListener)objectArray[i + 1]).datasetChanged(datasetChangeEvent);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        AbstractDataset abstractDataset = (AbstractDataset)super.clone();
        abstractDataset.listenerList = new EventListenerList();
        return abstractDataset;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.listenerList = new EventListenerList();
        objectInputStream.registerValidation(this, 10);
    }

    public void validateObject() throws InvalidObjectException {
        this.fireDatasetChanged();
    }
}

