/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;

public class TaskSeriesTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskSeriesTests.class);
    }

    public TaskSeriesTests(String string) {
        super(string);
    }

    public void testEquals() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = new TaskSeries("S");
        taskSeries2.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesTests.assertTrue((boolean)taskSeries.equals(taskSeries2));
        TaskSeriesTests.assertTrue((boolean)taskSeries2.equals(taskSeries));
        taskSeries.add(new Task("T3", new Date(22L), new Date(33L)));
        TaskSeriesTests.assertFalse((boolean)taskSeries.equals(taskSeries2));
        taskSeries2.add(new Task("T3", new Date(22L), new Date(33L)));
        TaskSeriesTests.assertTrue((boolean)taskSeries.equals(taskSeries2));
    }

    public void testCloning() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = null;
        try {
            taskSeries2 = (TaskSeries)taskSeries.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        TaskSeriesTests.assertTrue((taskSeries != taskSeries2 ? 1 : 0) != 0);
        TaskSeriesTests.assertTrue((taskSeries.getClass() == taskSeries2.getClass() ? 1 : 0) != 0);
        TaskSeriesTests.assertTrue((boolean)taskSeries.equals(taskSeries2));
    }

    public void testSerialization() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(taskSeries);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            taskSeries2 = (TaskSeries)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TaskSeriesTests.assertEquals((Object)taskSeries, taskSeries2);
    }

    public void testGetTask() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        Task task = taskSeries.get("T1");
        TaskSeriesTests.assertTrue((boolean)task.equals(new Task("T1", new Date(1L), new Date(2L))));
        Task task2 = taskSeries.get("T2");
        TaskSeriesTests.assertTrue((boolean)task2.equals(new Task("T2", new Date(11L), new Date(22L))));
        Task task3 = taskSeries.get("T3");
        TaskSeriesTests.assertTrue((task3 == null ? 1 : 0) != 0);
    }
}

