/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;

public class TaskSeriesCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(TaskSeriesCollectionTests.class);
    }

    public TaskSeriesCollectionTests(String string) {
        super(string);
    }

    private TaskSeriesCollection createCollection1() {
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        TaskSeries taskSeries = new TaskSeries("S1");
        taskSeries.add(new Task("Task 1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("Task 2", new Date(3L), new Date(4L)));
        taskSeriesCollection.add(taskSeries);
        TaskSeries taskSeries2 = new TaskSeries("S2");
        taskSeries2.add(new Task("Task 3", new Date(5L), new Date(6L)));
        taskSeriesCollection.add(taskSeries2);
        return taskSeriesCollection;
    }

    private TaskSeriesCollection createCollection2() {
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        TaskSeries taskSeries = new TaskSeries("S1");
        Task task = new Task("Task 1", new Date(10L), new Date(20L));
        task.addSubtask(new Task("Task 1A", new Date(10L), new Date(15L)));
        task.addSubtask(new Task("Task 1B", new Date(16L), new Date(20L)));
        task.setPercentComplete(0.1);
        taskSeries.add(task);
        Task task2 = new Task("Task 2", new Date(30L), new Date(40L));
        task2.addSubtask(new Task("Task 2A", new Date(30L), new Date(35L)));
        task2.addSubtask(new Task("Task 2B", new Date(36L), new Date(40L)));
        task2.setPercentComplete(0.2);
        taskSeries.add(task2);
        taskSeriesCollection.add(taskSeries);
        TaskSeries taskSeries2 = new TaskSeries("S2");
        Task task3 = new Task("Task 3", new Date(50L), new Date(60L));
        task3.addSubtask(new Task("Task 3A", new Date(50L), new Date(55L)));
        task3.addSubtask(new Task("Task 3B", new Date(56L), new Date(60L)));
        task3.setPercentComplete(0.3);
        taskSeries2.add(task3);
        taskSeriesCollection.add(taskSeries2);
        return taskSeriesCollection;
    }

    private TaskSeriesCollection createCollection3() {
        Task task = new Task("Sub1", new Date(11L), new Date(111L));
        Task task2 = new Task("Sub2", new Date(22L), new Date(222L));
        Task task3 = new Task("Sub3", new Date(33L), new Date(333L));
        Task task4 = new Task("Sub4", new Date(44L), new Date(444L));
        Task task5 = new Task("Sub5", new Date(55L), new Date(555L));
        Task task6 = new Task("Sub6", new Date(66L), new Date(666L));
        task.setPercentComplete(0.111);
        task2.setPercentComplete(0.222);
        task3.setPercentComplete(0.333);
        task4.setPercentComplete(0.444);
        task5.setPercentComplete(0.555);
        task6.setPercentComplete(0.666);
        TaskSeries taskSeries = new TaskSeries("Series A");
        Task task7 = new Task("Task 1", new SimpleTimePeriod(new Date(100L), new Date(200L)));
        task7.setPercentComplete(0.1);
        task7.addSubtask(task);
        Task task8 = new Task("Task 2", new SimpleTimePeriod(new Date(220L), new Date(350L)));
        task8.setPercentComplete(0.2);
        task8.addSubtask(task2);
        task8.addSubtask(task3);
        taskSeries.add(task7);
        taskSeries.add(task8);
        TaskSeries taskSeries2 = new TaskSeries("Series B");
        Task task9 = new Task("Task 2", new SimpleTimePeriod(new Date(2220L), new Date(3350L)));
        task9.setPercentComplete(0.3);
        task9.addSubtask(task4);
        task9.addSubtask(task5);
        task9.addSubtask(task6);
        taskSeries2.add(task9);
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        return taskSeriesCollection;
    }

    public void testGetSeriesCount() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)2, (int)taskSeriesCollection.getSeriesCount());
    }

    public void testGetSeriesKey() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"S1", (Object)taskSeriesCollection.getSeriesKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"S2", (Object)taskSeriesCollection.getSeriesKey(1));
    }

    public void testGetRowCount() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)2, (int)taskSeriesCollection.getRowCount());
    }

    public void testGetRowKey() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"S1", (Object)taskSeriesCollection.getRowKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"S2", (Object)taskSeriesCollection.getRowKey(1));
    }

    public void testGetRowIndex() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)0, (int)taskSeriesCollection.getRowIndex((Comparable)((Object)"S1")));
        TaskSeriesCollectionTests.assertEquals((int)1, (int)taskSeriesCollection.getRowIndex((Comparable)((Object)"S2")));
    }

    public void testGetValue() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)taskSeriesCollection.getValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)taskSeriesCollection.getValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)taskSeriesCollection.getValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)taskSeriesCollection.getValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)taskSeriesCollection.getValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)taskSeriesCollection.getValue(1, 2));
    }

    public void testGetStartValue() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(1L), (Object)taskSeriesCollection.getStartValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3L), (Object)taskSeriesCollection.getStartValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getStartValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getStartValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getStartValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(5L), (Object)taskSeriesCollection.getStartValue(1, 2));
        TaskSeriesCollection taskSeriesCollection2 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(100L), (Object)taskSeriesCollection2.getStartValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(220L), (Object)taskSeriesCollection2.getStartValue(0, 1));
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection2.getStartValue(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2220L), (Object)taskSeriesCollection2.getStartValue(1, 1));
    }

    public void testGetStartValue2() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(10L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(16L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(30L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(36L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(50L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(56L), (Object)taskSeriesCollection.getStartValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(10L), (Object)taskSeriesCollection.getStartValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(16L), (Object)taskSeriesCollection.getStartValue(0, 0, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(30L), (Object)taskSeriesCollection.getStartValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(36L), (Object)taskSeriesCollection.getStartValue(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(50L), (Object)taskSeriesCollection.getStartValue(1, 2, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(56L), (Object)taskSeriesCollection.getStartValue(1, 2, 1));
        TaskSeriesCollection taskSeriesCollection2 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(11L), (Object)taskSeriesCollection2.getStartValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(22L), (Object)taskSeriesCollection2.getStartValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(33L), (Object)taskSeriesCollection2.getStartValue(0, 1, 1));
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection2.getStartValue(1, 0, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(44L), (Object)taskSeriesCollection2.getStartValue(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)taskSeriesCollection2.getStartValue(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(66L), (Object)taskSeriesCollection2.getStartValue(1, 1, 2));
    }

    public void testGetEndValue() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(4L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(6L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(2L), (Object)taskSeriesCollection.getEndValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(4L), (Object)taskSeriesCollection.getEndValue(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getEndValue(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getEndValue(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getEndValue(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(6L), (Object)taskSeriesCollection.getEndValue(1, 2));
        TaskSeriesCollection taskSeriesCollection2 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(200L), (Object)taskSeriesCollection2.getEndValue(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(350L), (Object)taskSeriesCollection2.getEndValue(0, 1));
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection2.getEndValue(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(3350L), (Object)taskSeriesCollection2.getEndValue(1, 1));
    }

    public void testGetEndValue2() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(15L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(20L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(35L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(40L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(60L), (Object)taskSeriesCollection.getEndValue((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3"), 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(15L), (Object)taskSeriesCollection.getEndValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(20L), (Object)taskSeriesCollection.getEndValue(0, 0, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(35L), (Object)taskSeriesCollection.getEndValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(40L), (Object)taskSeriesCollection.getEndValue(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(55L), (Object)taskSeriesCollection.getEndValue(1, 2, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(60L), (Object)taskSeriesCollection.getEndValue(1, 2, 1));
        TaskSeriesCollection taskSeriesCollection2 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Long(111L), (Object)taskSeriesCollection2.getEndValue(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(222L), (Object)taskSeriesCollection2.getEndValue(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(333L), (Object)taskSeriesCollection2.getEndValue(0, 1, 1));
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection2.getEndValue(1, 0, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Long(444L), (Object)taskSeriesCollection2.getEndValue(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(555L), (Object)taskSeriesCollection2.getEndValue(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Long(666L), (Object)taskSeriesCollection2.getEndValue(1, 1, 2));
    }

    public void testGetPercentComplete() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection2();
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)taskSeriesCollection.getPercentComplete((Comparable)((Object)"S1"), (Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)taskSeriesCollection.getPercentComplete((Comparable)((Object)"S1"), (Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)taskSeriesCollection.getPercentComplete((Comparable)((Object)"S2"), (Comparable)((Object)"Task 3")));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)taskSeriesCollection.getPercentComplete(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)taskSeriesCollection.getPercentComplete(0, 1));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getPercentComplete(0, 2));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getPercentComplete(1, 0));
        TaskSeriesCollectionTests.assertEquals(null, (Object)taskSeriesCollection.getPercentComplete(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)taskSeriesCollection.getPercentComplete(1, 2));
        TaskSeriesCollection taskSeriesCollection2 = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.1), (Object)taskSeriesCollection2.getPercentComplete(0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.2), (Object)taskSeriesCollection2.getPercentComplete(0, 1));
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection2.getPercentComplete(1, 0) == null ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.3), (Object)taskSeriesCollection2.getPercentComplete(1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.111), (Object)taskSeriesCollection2.getPercentComplete(0, 0, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.222), (Object)taskSeriesCollection2.getPercentComplete(0, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.333), (Object)taskSeriesCollection2.getPercentComplete(0, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.444), (Object)taskSeriesCollection2.getPercentComplete(1, 1, 0));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.555), (Object)taskSeriesCollection2.getPercentComplete(1, 1, 1));
        TaskSeriesCollectionTests.assertEquals((Object)new Double(0.666), (Object)taskSeriesCollection2.getPercentComplete(1, 1, 2));
    }

    public void testGetColumnCount() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)3, (int)taskSeriesCollection.getColumnCount());
    }

    public void testGetColumnKey() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((Object)"Task 1", (Object)taskSeriesCollection.getColumnKey(0));
        TaskSeriesCollectionTests.assertEquals((Object)"Task 2", (Object)taskSeriesCollection.getColumnKey(1));
        TaskSeriesCollectionTests.assertEquals((Object)"Task 3", (Object)taskSeriesCollection.getColumnKey(2));
    }

    public void testGetColumnIndex() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection1();
        TaskSeriesCollectionTests.assertEquals((int)0, (int)taskSeriesCollection.getColumnIndex((Comparable)((Object)"Task 1")));
        TaskSeriesCollectionTests.assertEquals((int)1, (int)taskSeriesCollection.getColumnIndex((Comparable)((Object)"Task 2")));
        TaskSeriesCollectionTests.assertEquals((int)2, (int)taskSeriesCollection.getColumnIndex((Comparable)((Object)"Task 3")));
    }

    public void testEquals() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = new TaskSeries("S");
        taskSeries2.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        TaskSeries taskSeries3 = new TaskSeries("S");
        taskSeries3.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries3.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries4 = new TaskSeries("S");
        taskSeries4.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries4.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection taskSeriesCollection2 = new TaskSeriesCollection();
        taskSeriesCollection2.add(taskSeries3);
        taskSeriesCollection2.add(taskSeries4);
        TaskSeriesCollectionTests.assertTrue((boolean)taskSeriesCollection.equals(taskSeriesCollection2));
        TaskSeriesCollectionTests.assertTrue((boolean)taskSeriesCollection2.equals(taskSeriesCollection));
    }

    public void testCloning() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = new TaskSeries("S");
        taskSeries2.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        TaskSeriesCollection taskSeriesCollection2 = null;
        try {
            taskSeriesCollection2 = (TaskSeriesCollection)taskSeriesCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection != taskSeriesCollection2 ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertTrue((taskSeriesCollection.getClass() == taskSeriesCollection2.getClass() ? 1 : 0) != 0);
        TaskSeriesCollectionTests.assertTrue((boolean)taskSeriesCollection.equals(taskSeriesCollection2));
    }

    public void testSerialization() {
        TaskSeries taskSeries = new TaskSeries("S");
        taskSeries.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeries taskSeries2 = new TaskSeries("S");
        taskSeries2.add(new Task("T1", new Date(1L), new Date(2L)));
        taskSeries2.add(new Task("T2", new Date(11L), new Date(22L)));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        TaskSeriesCollection taskSeriesCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(taskSeriesCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            taskSeriesCollection2 = (TaskSeriesCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        TaskSeriesCollectionTests.assertEquals((Object)taskSeriesCollection, taskSeriesCollection2);
    }

    public void test697153() {
        TaskSeries taskSeries = new TaskSeries("S1");
        taskSeries.add(new Task("Task 1", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeries taskSeries2 = new TaskSeries("S2");
        taskSeries2.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries2.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries2.add(new Task("Task 4", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        taskSeries.removeAll();
        int n = taskSeriesCollection.getColumnCount();
        TaskSeriesCollectionTests.assertEquals((int)3, (int)n);
    }

    public void test800324() {
        TaskSeries taskSeries = new TaskSeries("S1");
        taskSeries.add(new Task("Task 1", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries.add(new Task("Task 2", new SimpleTimePeriod(new Date(), new Date())));
        taskSeries.add(new Task("Task 3", new SimpleTimePeriod(new Date(), new Date())));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        try {
            taskSeriesCollection.getStartValue(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            taskSeriesCollection.getEndValue(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        try {
            taskSeriesCollection.getSubIntervalCount(0, 3);
            TaskSeriesCollectionTests.assertTrue((boolean)false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testGetSubIntervalCount() {
        TaskSeriesCollection taskSeriesCollection = this.createCollection3();
        TaskSeriesCollectionTests.assertEquals((int)1, (int)taskSeriesCollection.getSubIntervalCount(0, 0));
        TaskSeriesCollectionTests.assertEquals((int)2, (int)taskSeriesCollection.getSubIntervalCount(0, 1));
        TaskSeriesCollectionTests.assertEquals((int)0, (int)taskSeriesCollection.getSubIntervalCount(1, 0));
        TaskSeriesCollectionTests.assertEquals((int)3, (int)taskSeriesCollection.getSubIntervalCount(1, 1));
    }
}

