/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.gantt;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.general.AbstractSeriesDataset;
import org.jfree.data.general.SeriesChangeEvent;
import org.jfree.data.time.TimePeriod;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;

public class TaskSeriesCollection
extends AbstractSeriesDataset
implements GanttCategoryDataset,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -2065799050738449903L;
    private List keys = new ArrayList();
    private List data = new ArrayList();

    public int getSeriesCount() {
        return this.getRowCount();
    }

    public Comparable getSeriesKey(int n) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        return taskSeries.getKey();
    }

    public int getRowCount() {
        return this.data.size();
    }

    public List getRowKeys() {
        return this.data;
    }

    public int getColumnCount() {
        return this.keys.size();
    }

    public List getColumnKeys() {
        return this.keys;
    }

    public Comparable getColumnKey(int n) {
        return (Comparable)this.keys.get(n);
    }

    public int getColumnIndex(Comparable comparable) {
        return this.keys.indexOf(comparable);
    }

    public int getRowIndex(Comparable comparable) {
        int n = -1;
        int n2 = this.data.size();
        for (int i = 0; i < n2; ++i) {
            TaskSeries taskSeries = (TaskSeries)this.data.get(i);
            if (!taskSeries.getKey().equals(comparable)) continue;
            n = i;
            break;
        }
        return n;
    }

    public Comparable getRowKey(int n) {
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        return taskSeries.getKey();
    }

    public void add(TaskSeries taskSeries) {
        if (taskSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        this.data.add(taskSeries);
        taskSeries.addChangeListener(this);
        for (Task task : taskSeries.getTasks()) {
            String string = task.getDescription();
            int n = this.keys.indexOf(string);
            if (n >= 0) continue;
            this.keys.add(string);
        }
        this.fireDatasetChanged();
    }

    public void remove(TaskSeries taskSeries) {
        if (taskSeries == null) {
            throw new IllegalArgumentException("Null 'series' argument.");
        }
        if (this.data.contains(taskSeries)) {
            taskSeries.removeChangeListener(this);
            this.data.remove(taskSeries);
            this.fireDatasetChanged();
        }
    }

    public void remove(int n) {
        if (n < 0 || n > this.getSeriesCount()) {
            throw new IllegalArgumentException("TaskSeriesCollection.remove(): index outside valid range.");
        }
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        taskSeries.removeChangeListener(this);
        this.data.remove(n);
        this.fireDatasetChanged();
    }

    public void removeAll() {
        for (TaskSeries taskSeries : this.data) {
            taskSeries.removeChangeListener(this);
        }
        this.data.clear();
        this.fireDatasetChanged();
    }

    public Number getValue(Comparable comparable, Comparable comparable2) {
        return this.getStartValue(comparable, comparable2);
    }

    public Number getValue(int n, int n2) {
        return this.getStartValue(n, n2);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2) {
        Long l = null;
        int n = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            TimePeriod timePeriod = task.getDuration();
            l = new Long(timePeriod.getStart().getTime());
        }
        return l;
    }

    public Number getStartValue(int n, int n2) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getStartValue(comparable, comparable2);
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2) {
        Long l = null;
        int n = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            TimePeriod timePeriod = task.getDuration();
            l = new Long(timePeriod.getEnd().getTime());
        }
        return l;
    }

    public Number getEndValue(int n, int n2) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getEndValue(comparable, comparable2);
    }

    public Number getPercentComplete(int n, int n2) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getPercentComplete(comparable, comparable2);
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2) {
        Double d = null;
        int n = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            d = task.getPercentComplete();
        }
        return d;
    }

    public int getSubIntervalCount(int n, int n2) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getSubIntervalCount(comparable, comparable2);
    }

    public int getSubIntervalCount(Comparable comparable, Comparable comparable2) {
        int n = 0;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task = taskSeries.get(comparable2.toString());
        if (task != null) {
            n = task.getSubtaskCount();
        }
        return n;
    }

    public Number getStartValue(int n, int n2, int n3) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getStartValue(comparable, comparable2, n3);
    }

    public Number getStartValue(Comparable comparable, Comparable comparable2, int n) {
        Task task;
        Long l = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n)) != null) {
            TimePeriod timePeriod = task.getDuration();
            l = new Long(timePeriod.getStart().getTime());
        }
        return l;
    }

    public Number getEndValue(int n, int n2, int n3) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getEndValue(comparable, comparable2, n3);
    }

    public Number getEndValue(Comparable comparable, Comparable comparable2, int n) {
        Task task;
        Long l = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n)) != null) {
            TimePeriod timePeriod = task.getDuration();
            l = new Long(timePeriod.getEnd().getTime());
        }
        return l;
    }

    public Number getPercentComplete(int n, int n2, int n3) {
        Comparable comparable = this.getRowKey(n);
        Comparable comparable2 = this.getColumnKey(n2);
        return this.getPercentComplete(comparable, comparable2, n3);
    }

    public Number getPercentComplete(Comparable comparable, Comparable comparable2, int n) {
        Task task;
        Double d = null;
        int n2 = this.getRowIndex(comparable);
        TaskSeries taskSeries = (TaskSeries)this.data.get(n2);
        Task task2 = taskSeries.get(comparable2.toString());
        if (task2 != null && (task = task2.getSubtask(n)) != null) {
            d = task.getPercentComplete();
        }
        return d;
    }

    public void seriesChanged(SeriesChangeEvent seriesChangeEvent) {
        this.refreshKeys();
        this.fireDatasetChanged();
    }

    private void refreshKeys() {
        this.keys.clear();
        for (int i = 0; i < this.getSeriesCount(); ++i) {
            TaskSeries taskSeries = (TaskSeries)this.data.get(i);
            for (Task task : taskSeries.getTasks()) {
                String string = task.getDescription();
                int n = this.keys.indexOf(string);
                if (n >= 0) continue;
                this.keys.add(string);
            }
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TaskSeriesCollection)) {
            return false;
        }
        TaskSeriesCollection taskSeriesCollection = (TaskSeriesCollection)object;
        return ObjectUtilities.equal(this.data, taskSeriesCollection.data);
    }
}

