/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.data.category.DefaultCategoryDataset;

public class DefaultCategoryDatasetTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(DefaultCategoryDatasetTests.class);
    }

    public DefaultCategoryDatasetTests(String string) {
        super(string);
    }

    public void testGetRowCount() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getRowCount() == 0 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getRowCount() == 1 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getRowCount() == 2 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getRowCount() == 2 ? 1 : 0) != 0);
        defaultCategoryDataset.setValue(null, (Comparable)((Object)"R2"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getRowCount() == 2 ? 1 : 0) != 0);
    }

    public void testGetColumnCount() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getColumnCount() == 0 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getColumnCount() == 1 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getColumnCount() == 2 ? 1 : 0) != 0);
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getColumnCount() == 2 ? 1 : 0) != 0);
        defaultCategoryDataset.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((defaultCategoryDataset.getColumnCount() == 2 ? 1 : 0) != 0);
    }

    public void testEquals() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
        defaultCategoryDataset2.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((boolean)defaultCategoryDataset.equals(defaultCategoryDataset2));
        DefaultCategoryDatasetTests.assertTrue((boolean)defaultCategoryDataset2.equals(defaultCategoryDataset));
        defaultCategoryDataset.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertFalse((boolean)defaultCategoryDataset.equals(defaultCategoryDataset2));
        defaultCategoryDataset2.setValue(36.5, (Comparable)((Object)"R1"), (Comparable)((Object)"C2"));
        DefaultCategoryDatasetTests.assertTrue((boolean)defaultCategoryDataset.equals(defaultCategoryDataset2));
        defaultCategoryDataset.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertFalse((boolean)defaultCategoryDataset.equals(defaultCategoryDataset2));
        defaultCategoryDataset2.setValue(null, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDatasetTests.assertTrue((boolean)defaultCategoryDataset.equals(defaultCategoryDataset2));
    }

    public void testSerialization() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.setValue(23.4, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        DefaultCategoryDataset defaultCategoryDataset2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(defaultCategoryDataset);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            defaultCategoryDataset2 = (DefaultCategoryDataset)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        DefaultCategoryDatasetTests.assertEquals((Object)defaultCategoryDataset, defaultCategoryDataset2);
    }
}

