/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.data.category;

import java.util.List;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.general.DatasetChangeEvent;
import org.jfree.data.general.DatasetChangeListener;
import org.jfree.data.general.PieDataset;
import org.jfree.util.TableOrder;

public class CategoryToPieDataset
extends AbstractDataset
implements PieDataset,
DatasetChangeListener {
    private CategoryDataset source;
    private TableOrder extract;
    private int index;

    public CategoryToPieDataset(CategoryDataset categoryDataset, TableOrder tableOrder, int n) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'extract' argument.");
        }
        this.source = categoryDataset;
        this.source.addChangeListener(this);
        this.extract = tableOrder;
        this.index = n;
    }

    public int getItemCount() {
        int n = 0;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                n = this.source.getColumnCount();
            } else if (this.extract == TableOrder.BY_COLUMN) {
                n = this.source.getRowCount();
            }
        }
        return n;
    }

    public Number getValue(int n) {
        Number number = null;
        if (this.source != null) {
            if (this.extract == TableOrder.BY_ROW) {
                number = this.source.getValue(this.index, n);
            } else if (this.extract == TableOrder.BY_COLUMN) {
                number = this.source.getValue(n, this.index);
            }
        }
        return number;
    }

    public Comparable getKey(int n) {
        Comparable comparable = null;
        if (this.extract == TableOrder.BY_ROW) {
            comparable = this.source.getColumnKey(n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            comparable = this.source.getRowKey(n);
        }
        return comparable;
    }

    public int getIndex(Comparable comparable) {
        int n = -1;
        if (this.extract == TableOrder.BY_ROW) {
            n = this.source.getColumnIndex(comparable);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            n = this.source.getRowIndex(comparable);
        }
        return n;
    }

    public List getKeys() {
        List list = null;
        if (this.extract == TableOrder.BY_ROW) {
            list = this.source.getColumnKeys();
        } else if (this.extract == TableOrder.BY_COLUMN) {
            list = this.source.getRowKeys();
        }
        return list;
    }

    public Number getValue(Comparable comparable) {
        Number number = null;
        int n = this.getIndex(comparable);
        if (this.extract == TableOrder.BY_ROW) {
            number = this.source.getValue(this.index, n);
        } else if (this.extract == TableOrder.BY_COLUMN) {
            number = this.source.getValue(n, this.index);
        }
        return number;
    }

    public void datasetChanged(DatasetChangeEvent datasetChangeEvent) {
        this.fireDatasetChanged();
    }
}

