/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title.junit;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.title.LegendTitle;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleEdge;

public class LegendTitleTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LegendTitleTests.class);
    }

    public LegendTitleTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYPlot xYPlot = new XYPlot();
        LegendTitle legendTitle = new LegendTitle(xYPlot);
        LegendTitle legendTitle2 = new LegendTitle(xYPlot);
        LegendTitleTests.assertEquals((Object)legendTitle, (Object)legendTitle2);
        legendTitle.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitleTests.assertFalse((boolean)legendTitle.equals(legendTitle2));
        legendTitle2.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
        legendTitle.setLegendItemGraphicEdge(RectangleEdge.BOTTOM);
        LegendTitleTests.assertFalse((boolean)legendTitle.equals(legendTitle2));
        legendTitle2.setLegendItemGraphicEdge(RectangleEdge.BOTTOM);
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
        legendTitle.setLegendItemGraphicAnchor(RectangleAnchor.BOTTOM_LEFT);
        LegendTitleTests.assertFalse((boolean)legendTitle.equals(legendTitle2));
        legendTitle2.setLegendItemGraphicAnchor(RectangleAnchor.BOTTOM_LEFT);
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
        legendTitle.setLegendItemGraphicLocation(RectangleAnchor.TOP_LEFT);
        LegendTitleTests.assertFalse((boolean)legendTitle.equals(legendTitle2));
        legendTitle2.setLegendItemGraphicLocation(RectangleAnchor.TOP_LEFT);
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
        legendTitle.setItemFont(new Font("Dialog", 0, 19));
        LegendTitleTests.assertFalse((boolean)legendTitle.equals(legendTitle2));
        legendTitle2.setItemFont(new Font("Dialog", 0, 19));
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
    }

    public void testHashcode() {
        XYPlot xYPlot = new XYPlot();
        LegendTitle legendTitle = new LegendTitle(xYPlot);
        LegendTitle legendTitle2 = new LegendTitle(xYPlot);
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
        int n = legendTitle.hashCode();
        int n2 = legendTitle2.hashCode();
        LegendTitleTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        XYPlot xYPlot = new XYPlot();
        LegendTitle legendTitle = new LegendTitle(xYPlot);
        legendTitle.setBackgroundPaint(new GradientPaint(1.0f, 2.0f, Color.red, 3.0f, 4.0f, Color.yellow));
        LegendTitle legendTitle2 = null;
        try {
            legendTitle2 = (LegendTitle)legendTitle.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        LegendTitleTests.assertTrue((legendTitle != legendTitle2 ? 1 : 0) != 0);
        LegendTitleTests.assertTrue((legendTitle.getClass() == legendTitle2.getClass() ? 1 : 0) != 0);
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
    }

    public void testSerialization() {
        XYPlot xYPlot = new XYPlot();
        LegendTitle legendTitle = new LegendTitle(xYPlot);
        LegendTitle legendTitle2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(legendTitle);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            legendTitle2 = (LegendTitle)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            LegendTitleTests.fail((String)exception.toString());
        }
        LegendTitleTests.assertTrue((boolean)legendTitle.equals(legendTitle2));
    }
}

