/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.title;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.Rectangle2D;
import org.jfree.chart.event.TitleChangeEvent;
import org.jfree.chart.title.Title;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.Size2D;
import org.jfree.ui.VerticalAlignment;

public class ImageTitle
extends Title {
    private Image image;
    private int height;
    private int width;

    public ImageTitle(Image image) {
        this(image, image.getHeight(null), image.getWidth(null), Title.DEFAULT_POSITION, Title.DEFAULT_HORIZONTAL_ALIGNMENT, Title.DEFAULT_VERTICAL_ALIGNMENT, Title.DEFAULT_PADDING);
    }

    public ImageTitle(Image image, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment) {
        this(image, image.getHeight(null), image.getWidth(null), rectangleEdge, horizontalAlignment, verticalAlignment, Title.DEFAULT_PADDING);
    }

    public ImageTitle(Image image, int n, int n2, RectangleEdge rectangleEdge, HorizontalAlignment horizontalAlignment, VerticalAlignment verticalAlignment, RectangleInsets rectangleInsets) {
        super(rectangleEdge, horizontalAlignment, verticalAlignment, rectangleInsets);
        if (image == null) {
            throw new NullPointerException("Null 'image' argument.");
        }
        this.image = image;
        this.height = n;
        this.width = n2;
    }

    public Image getImage() {
        return this.image;
    }

    public void setImage(Image image) {
        if (image == null) {
            throw new NullPointerException("Null 'image' argument.");
        }
        this.image = image;
        this.notifyListeners(new TitleChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        RectangleEdge rectangleEdge = this.getPosition();
        if (rectangleEdge == RectangleEdge.TOP || rectangleEdge == RectangleEdge.BOTTOM) {
            this.drawHorizontal(graphics2D, rectangle2D);
        } else if (rectangleEdge == RectangleEdge.LEFT || rectangleEdge == RectangleEdge.RIGHT) {
            this.drawVertical(graphics2D, rectangle2D);
        } else {
            throw new RuntimeException("Invalid title position.");
        }
    }

    protected Size2D drawHorizontal(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        RectangleInsets rectangleInsets = this.getPadding();
        d2 = rectangleInsets.calculateTopOutset(this.height);
        d3 = rectangleInsets.calculateBottomOutset(this.height);
        d4 = rectangleInsets.calculateLeftOutset(this.width);
        d5 = rectangleInsets.calculateRightOutset(this.width);
        d = this.getPosition() == RectangleEdge.TOP ? rectangle2D.getY() + d2 : rectangle2D.getY() + rectangle2D.getHeight() - d3 - (double)this.height;
        HorizontalAlignment horizontalAlignment = this.getHorizontalAlignment();
        double d6 = 0.0;
        if (horizontalAlignment == HorizontalAlignment.CENTER) {
            d6 = rectangle2D.getX() + d4 + rectangle2D.getWidth() / 2.0 - (double)this.width / 2.0;
        } else if (horizontalAlignment == HorizontalAlignment.LEFT) {
            d6 = rectangle2D.getX() + d4;
        } else if (horizontalAlignment == HorizontalAlignment.RIGHT) {
            d6 = rectangle2D.getX() + rectangle2D.getWidth() - d5 - (double)this.width;
        }
        graphics2D.drawImage(this.image, (int)d6, (int)d, this.width, this.height, null);
        return new Size2D(rectangle2D.getWidth() + d4 + d5, (double)this.height + d2 + d3);
    }

    protected Size2D drawVertical(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        RectangleInsets rectangleInsets = this.getPadding();
        if (rectangleInsets != null) {
            d2 = rectangleInsets.calculateTopOutset(this.height);
            d3 = rectangleInsets.calculateBottomOutset(this.height);
            d4 = rectangleInsets.calculateLeftOutset(this.width);
            d5 = rectangleInsets.calculateRightOutset(this.width);
        }
        d = this.getPosition() == RectangleEdge.LEFT ? rectangle2D.getX() + d4 : rectangle2D.getMaxX() - d5 - (double)this.width;
        VerticalAlignment verticalAlignment = this.getVerticalAlignment();
        double d6 = 0.0;
        if (verticalAlignment == VerticalAlignment.CENTER) {
            d6 = rectangle2D.getMinY() + d2 + rectangle2D.getHeight() / 2.0 - (double)this.height / 2.0;
        } else if (verticalAlignment == VerticalAlignment.TOP) {
            d6 = rectangle2D.getMinY() + d2;
        } else if (verticalAlignment == VerticalAlignment.BOTTOM) {
            d6 = rectangle2D.getMaxY() - d3 - (double)this.height;
        }
        graphics2D.drawImage(this.image, (int)d, (int)d6, this.width, this.height, null);
        return new Size2D(rectangle2D.getWidth() + d4 + d5, (double)this.height + d2 + d3);
    }

    public Object draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Object object) {
        this.draw(graphics2D, rectangle2D);
        return null;
    }
}

