/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.chart.renderer.xy.junit.RendererXYPackageTests;
import org.jfree.data.Range;
import org.jfree.data.xy.TableXYDataset;

public class StackedXYBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StackedXYBarRendererTests.class);
    }

    public StackedXYBarRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer();
        StackedXYBarRenderer stackedXYBarRenderer2 = new StackedXYBarRenderer();
        StackedXYBarRendererTests.assertTrue((boolean)stackedXYBarRenderer.equals(stackedXYBarRenderer2));
        StackedXYBarRendererTests.assertTrue((boolean)stackedXYBarRenderer2.equals(stackedXYBarRenderer));
    }

    public void testHashcode() {
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer();
        StackedXYBarRenderer stackedXYBarRenderer2 = new StackedXYBarRenderer();
        StackedXYBarRendererTests.assertTrue((boolean)stackedXYBarRenderer.equals(stackedXYBarRenderer2));
        int n = stackedXYBarRenderer.hashCode();
        int n2 = stackedXYBarRenderer2.hashCode();
        StackedXYBarRendererTests.assertEquals((int)n, (int)n2);
    }

    public void testCloning() {
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer();
        StackedXYBarRenderer stackedXYBarRenderer2 = null;
        try {
            stackedXYBarRenderer2 = (StackedXYBarRenderer)stackedXYBarRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StackedXYBarRendererTests.assertTrue((stackedXYBarRenderer != stackedXYBarRenderer2 ? 1 : 0) != 0);
        StackedXYBarRendererTests.assertTrue((stackedXYBarRenderer.getClass() == stackedXYBarRenderer2.getClass() ? 1 : 0) != 0);
        StackedXYBarRendererTests.assertTrue((boolean)stackedXYBarRenderer.equals(stackedXYBarRenderer2));
    }

    public void testSerialization() {
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer();
        StackedXYBarRenderer stackedXYBarRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(stackedXYBarRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            stackedXYBarRenderer2 = (StackedXYBarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StackedXYBarRendererTests.assertEquals((Object)stackedXYBarRenderer, stackedXYBarRenderer2);
    }

    public void testFindDomainBounds() {
        TableXYDataset tableXYDataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", tableXYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setRenderer(new StackedXYBarRenderer());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        Range range = numberAxis.getRange();
        StackedXYBarRendererTests.assertFalse((boolean)range.contains(0.3));
        StackedXYBarRendererTests.assertTrue((boolean)range.contains(0.5));
        StackedXYBarRendererTests.assertTrue((boolean)range.contains(2.5));
        StackedXYBarRendererTests.assertFalse((boolean)range.contains(2.8));
    }

    public void testFindRangeBounds() {
        TableXYDataset tableXYDataset = RendererXYPackageTests.createTestTableXYDataset();
        JFreeChart jFreeChart = ChartFactory.createStackedXYAreaChart("Test Chart", "X", "Y", tableXYDataset, PlotOrientation.VERTICAL, false, false, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setRenderer(new StackedXYBarRenderer());
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        Range range = numberAxis.getRange();
        StackedXYBarRendererTests.assertTrue((boolean)range.contains(6.0));
        StackedXYBarRendererTests.assertTrue((boolean)range.contains(8.0));
    }
}

