/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYZDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class XYBubbleRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    public static final long serialVersionUID = -5221991598674249125L;
    public static final int SCALE_ON_BOTH_AXES = 0;
    public static final int SCALE_ON_DOMAIN_AXIS = 1;
    public static final int SCALE_ON_RANGE_AXIS = 2;
    private int scaleType;

    public XYBubbleRenderer() {
        this(0);
    }

    public XYBubbleRenderer(int n) {
        this.scaleType = n;
    }

    public int getScaleType() {
        return this.scaleType;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        double d = xYDataset.getXValue(n, n2);
        double d2 = xYDataset.getYValue(n, n2);
        double d3 = Double.NaN;
        if (xYDataset instanceof XYZDataset) {
            object = (XYZDataset)xYDataset;
            d3 = object.getZValue(n, n2);
        }
        if (!Double.isNaN(d3)) {
            object = xYPlot.getDomainAxisEdge();
            RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
            double d4 = valueAxis.valueToJava2D(d, rectangle2D, (RectangleEdge)object);
            double d5 = valueAxis2.valueToJava2D(d2, rectangle2D, rectangleEdge);
            double d6 = 0.0;
            double d7 = 0.0;
            switch (this.getScaleType()) {
                case 1: {
                    double d8 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)object);
                    d7 = d6 = valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)object) - d8;
                    break;
                }
                case 2: {
                    double d9 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d6 = d7 = d9 - valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge);
                    break;
                }
                default: {
                    double d10 = valueAxis.valueToJava2D(0.0, rectangle2D, (RectangleEdge)object);
                    double d11 = valueAxis2.valueToJava2D(0.0, rectangle2D, rectangleEdge);
                    d6 = valueAxis.valueToJava2D(d3, rectangle2D, (RectangleEdge)object) - d10;
                    d7 = d11 - valueAxis2.valueToJava2D(d3, rectangle2D, rectangleEdge);
                }
            }
            d6 = Math.abs(d6);
            d7 = Math.abs(d7);
            Ellipse2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7);
            } else if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Ellipse2D.Double(d5 - d7 / 2.0, d4 - d6 / 2.0, d7, d6);
            }
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.fill(double_);
            graphics2D.setStroke(new BasicStroke(1.0f));
            graphics2D.setPaint(Color.lightGray);
            graphics2D.draw(double_);
            EntityCollection entityCollection = null;
            if (plotRenderingInfo != null) {
                entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
            }
            if (entityCollection != null) {
                String string = null;
                XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (xYToolTipGenerator != null) {
                    string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
                }
                String string2 = null;
                if (this.getURLGenerator() != null) {
                    string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
                }
                XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
                entityCollection.add(xYItemEntity);
            }
            this.updateCrosshairValues(crosshairState, d, d2, d4, d5, plotOrientation);
        }
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null && this.getItemVisible(n2, 0)) {
            String string;
            String string2 = string = this.getLegendItemLabelGenerator().generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Ellipse2D.Double double_ = new Ellipse2D.Double(-4.0, -4.0, 8.0, 8.0);
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, double_, paint, stroke, paint2);
        }
        return legendItem;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

