/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.LegendItem;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYSeriesLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.GradientPaintTransformer;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.StandardGradientPaintTransformer;
import org.jfree.util.ObjectUtilities;
import org.jfree.util.PublicCloneable;
import org.jfree.util.ShapeUtilities;

public class XYBarRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 770559577251370036L;
    private double base;
    private boolean useYInterval;
    private double margin;
    private boolean drawBarOutline;
    private GradientPaintTransformer gradientPaintTransformer;
    private transient Shape legendBar;

    public XYBarRenderer() {
        this(0.0);
    }

    public XYBarRenderer(double d) {
        this.margin = d;
        this.base = 0.0;
        this.useYInterval = false;
        this.gradientPaintTransformer = new StandardGradientPaintTransformer();
        this.drawBarOutline = true;
        this.legendBar = new Rectangle2D.Double(-3.0, -5.0, 6.0, 10.0);
    }

    public double getBase() {
        return this.base;
    }

    public void setBase(double d) {
        this.base = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getUseYInterval() {
        return this.useYInterval;
    }

    public void setUseYInterval(boolean bl) {
        this.useYInterval = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public double getMargin() {
        return this.margin;
    }

    public void setMargin(double d) {
        this.margin = d;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean isDrawBarOutline() {
        return this.drawBarOutline;
    }

    public void setDrawBarOutline(boolean bl) {
        this.drawBarOutline = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public GradientPaintTransformer getGradientPaintTransformer() {
        return this.gradientPaintTransformer;
    }

    public void setGradientPaintTransformer(GradientPaintTransformer gradientPaintTransformer) {
        this.gradientPaintTransformer = gradientPaintTransformer;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public Shape getLegendBar() {
        return this.legendBar;
    }

    public void setLegendBar(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'bar' argument.");
        }
        this.legendBar = shape;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public XYItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, XYPlot xYPlot, XYDataset xYDataset, PlotRenderingInfo plotRenderingInfo) {
        XYBarRendererState xYBarRendererState = new XYBarRendererState(plotRenderingInfo);
        ValueAxis valueAxis = xYPlot.getRangeAxisForDataset(xYPlot.indexOf(xYDataset));
        xYBarRendererState.setG2Base(valueAxis.valueToJava2D(this.base, rectangle2D, xYPlot.getRangeAxisEdge()));
        return xYBarRendererState;
    }

    public LegendItem getLegendItem(int n, int n2) {
        XYDataset xYDataset;
        LegendItem legendItem = null;
        XYPlot xYPlot = this.getPlot();
        if (xYPlot != null && (xYDataset = xYPlot.getDataset(n)) != null) {
            String string;
            XYSeriesLabelGenerator xYSeriesLabelGenerator = this.getLegendItemLabelGenerator();
            String string2 = string = xYSeriesLabelGenerator.generateLabel(xYDataset, n2);
            String string3 = null;
            if (this.getLegendItemToolTipGenerator() != null) {
                string3 = this.getLegendItemToolTipGenerator().generateLabel(xYDataset, n2);
            }
            String string4 = null;
            if (this.getLegendItemURLGenerator() != null) {
                string4 = this.getLegendItemURLGenerator().generateLabel(xYDataset, n2);
            }
            Shape shape = this.legendBar;
            Paint paint = this.getSeriesPaint(n2);
            Paint paint2 = this.getSeriesOutlinePaint(n2);
            Stroke stroke = this.getSeriesOutlineStroke(n2);
            legendItem = new LegendItem(string, string2, string3, string4, shape, paint, stroke, paint2);
        }
        return legendItem;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        Object object2;
        double d;
        double d2;
        if (!this.getItemVisible(n, n2)) {
            return;
        }
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        if (this.useYInterval) {
            d2 = intervalXYDataset.getStartYValue(n, n2);
            d = intervalXYDataset.getEndYValue(n, n2);
        } else {
            d2 = this.base;
            d = intervalXYDataset.getYValue(n, n2);
        }
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return;
        }
        double d3 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        Number number = intervalXYDataset.getStartX(n, n2);
        if (number == null) {
            return;
        }
        double d5 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
        Number number2 = intervalXYDataset.getEndX(n, n2);
        if (number2 == null) {
            return;
        }
        double d6 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
        double d7 = Math.max(1.0, Math.abs(d6 - d5));
        double d8 = Math.abs(d4 - d3);
        if (this.getMargin() > 0.0) {
            double d9 = d7 * this.getMargin();
            d7 -= d9;
            d5 += d9 / 2.0;
        }
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d3, d4), d6, d8, d7);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d5, Math.min(d3, d4), d7, d8);
        }
        Paint paint = this.getItemPaint(n, n2);
        if (this.getGradientPaintTransformer() != null && paint instanceof GradientPaint) {
            object2 = (GradientPaint)paint;
            paint = this.getGradientPaintTransformer().transform((GradientPaint)object2, double_);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d6 - d5) > 3.0) {
            object2 = this.getItemOutlineStroke(n, n2);
            object = this.getItemOutlinePaint(n, n2);
            if (object2 != null && object != null) {
                graphics2D.setStroke((Stroke)object2);
                graphics2D.setPaint((Paint)object);
                graphics2D.draw(double_);
            }
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, double_.getCenterX(), ((RectangularShape)double_).getY(), d < 0.0);
        }
        if (plotRenderingInfo != null && (object2 = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, (String)object, string);
            object2.add(xYItemEntity);
        }
    }

    public Range findDomainBounds(XYDataset xYDataset) {
        if (xYDataset != null) {
            return DatasetUtilities.findDomainBounds(xYDataset, true);
        }
        return null;
    }

    public Object clone() throws CloneNotSupportedException {
        XYBarRenderer xYBarRenderer = (XYBarRenderer)super.clone();
        if (this.gradientPaintTransformer != null) {
            xYBarRenderer.gradientPaintTransformer = (GradientPaintTransformer)ObjectUtilities.clone(this.gradientPaintTransformer);
        }
        return xYBarRenderer;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof XYBarRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        XYBarRenderer xYBarRenderer = (XYBarRenderer)object;
        if (this.base != xYBarRenderer.base) {
            return false;
        }
        if (this.drawBarOutline != xYBarRenderer.drawBarOutline) {
            return false;
        }
        if (this.margin != xYBarRenderer.margin) {
            return false;
        }
        if (this.useYInterval != xYBarRenderer.useYInterval) {
            return false;
        }
        if (!ObjectUtilities.equal(this.gradientPaintTransformer, xYBarRenderer.gradientPaintTransformer)) {
            return false;
        }
        return ShapeUtilities.equal(this.legendBar, xYBarRenderer.legendBar);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.legendBar = SerialUtilities.readShape(objectInputStream);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeShape(this.legendBar, objectOutputStream);
    }

    protected class XYBarRendererState
    extends XYItemRendererState {
        private double g2Base;

        public XYBarRendererState(PlotRenderingInfo plotRenderingInfo) {
            super(plotRenderingInfo);
        }

        public double getG2Base() {
            return this.g2Base;
        }

        public void setG2Base(double d) {
            this.g2Base = d;
        }
    }
}

