/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.SignalsDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.util.PublicCloneable;

public class SignalRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 1161092564576638268L;
    private double markOffset = 5.0;
    private double shapeWidth = 15.0;
    private double shapeHeight = 25.0;

    public double getMarkOffset() {
        return this.markOffset;
    }

    public void setMarkOffset(double d) {
        this.markOffset = d;
    }

    public double getShapeWidth() {
        return this.shapeWidth;
    }

    public void setShapeWidth(double d) {
        this.shapeWidth = d;
    }

    public double getShapeHeight() {
        return this.shapeHeight;
    }

    public void setShapeHeight(double d) {
        this.shapeHeight = d;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        SignalsDataset signalsDataset = (SignalsDataset)xYDataset;
        Number number = signalsDataset.getX(n, n2);
        Number number2 = signalsDataset.getY(n, n2);
        int n4 = signalsDataset.getType(n, n2);
        double d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
        double d2 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, xYPlot.getRangeAxisEdge());
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        int n5 = 1;
        if (n4 == 1 || n4 == -2) {
            d2 += this.markOffset;
            n5 = -1;
        } else {
            d2 -= this.markOffset;
        }
        GeneralPath generalPath = new GeneralPath();
        if (n4 == 1 || n4 == -1) {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)(d + this.shapeWidth / 2.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d + this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight));
            generalPath.lineTo((float)(d - this.shapeWidth / 6.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)(d - this.shapeWidth / 2.0), (float)(d2 - (double)n5 * this.shapeHeight / 3.0));
            generalPath.lineTo((float)d, (float)d2);
        } else {
            generalPath.moveTo((float)d, (float)d2);
            generalPath.lineTo((float)d, (float)(d2 - (double)n5 * this.shapeHeight));
            object = new Ellipse2D.Double(d - this.shapeWidth / 2.0, d2 + (n5 == 1 ? -this.shapeHeight : this.shapeHeight - this.shapeWidth), this.shapeWidth, this.shapeWidth);
            generalPath.append((Shape)object, false);
        }
        graphics2D.fill(generalPath);
        graphics2D.setPaint(Color.black);
        graphics2D.draw(generalPath);
        if (entityCollection != null) {
            object = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                object = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string = null;
            if (this.getURLGenerator() != null) {
                string = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(generalPath, xYDataset, n, n2, (String)object, string);
            entityCollection.add(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

