/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.AbstractXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.OHLCDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class HighLowRenderer
extends AbstractXYItemRenderer
implements XYItemRenderer,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = -8135673815876552516L;
    private boolean drawOpenTicks = true;
    private boolean drawCloseTicks = true;

    public boolean getDrawOpenTicks() {
        return this.drawOpenTicks;
    }

    public void setDrawOpenTicks(boolean bl) {
        this.drawOpenTicks = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public boolean getDrawCloseTicks() {
        return this.drawCloseTicks;
    }

    public void setDrawCloseTicks(boolean bl) {
        this.drawCloseTicks = bl;
        this.notifyListeners(new RendererChangeEvent(this));
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        Object object;
        double d;
        Object object2;
        Number number = xYDataset.getX(n, n2);
        if (number == null) {
            return;
        }
        double d2 = number.doubleValue();
        if (!valueAxis.getRange().contains(d2)) {
            return;
        }
        double d3 = valueAxis.valueToJava2D(d2, rectangle2D, xYPlot.getDomainAxisEdge());
        Rectangle2D.Double double_ = null;
        EntityCollection entityCollection = null;
        if (plotRenderingInfo != null) {
            entityCollection = plotRenderingInfo.getOwner().getEntityCollection();
        }
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        RectangleEdge rectangleEdge = xYPlot.getRangeAxisEdge();
        Paint paint = this.getItemPaint(n, n2);
        Stroke stroke = this.getItemStroke(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.setStroke(stroke);
        if (xYDataset instanceof OHLCDataset) {
            double d4;
            double d5;
            double d6;
            object2 = (OHLCDataset)xYDataset;
            double d7 = object2.getHighValue(n, n2);
            d = object2.getLowValue(n, n2);
            if (!Double.isNaN(d7) && !Double.isNaN(d)) {
                d6 = valueAxis2.valueToJava2D(d7, rectangle2D, rectangleEdge);
                d5 = valueAxis2.valueToJava2D(d, rectangle2D, rectangleEdge);
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d5, d3, d6, d3));
                    double_ = new Rectangle2D.Double(Math.min(d5, d6), d3 - 1.0, Math.abs(d6 - d5), 2.0);
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d3, d5, d3, d6));
                    double_ = new Rectangle2D.Double(d3 - 1.0, Math.min(d5, d6), 2.0, Math.abs(d6 - d5));
                }
            }
            d6 = 2.0;
            if (valueAxis.isInverted()) {
                d6 = -d6;
            }
            if (this.getDrawOpenTicks() && !Double.isNaN(d5 = object2.getOpenValue(n, n2))) {
                d4 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d4, d3 + d6, d4, d3));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d3 - d6, d4, d3, d4));
                }
            }
            if (this.getDrawCloseTicks() && !Double.isNaN(d5 = object2.getCloseValue(n, n2))) {
                d4 = valueAxis2.valueToJava2D(d5, rectangle2D, rectangleEdge);
                if (plotOrientation == PlotOrientation.HORIZONTAL) {
                    graphics2D.draw(new Line2D.Double(d4, d3, d4, d3 - d6));
                } else if (plotOrientation == PlotOrientation.VERTICAL) {
                    graphics2D.draw(new Line2D.Double(d3, d4, d3 + d6, d4));
                }
            }
        } else if (n2 > 0) {
            object2 = xYDataset.getX(n, n2 - 1);
            Number number2 = xYDataset.getY(n, n2 - 1);
            object = xYDataset.getY(n, n2);
            if (object2 == null || number2 == null || object == null) {
                return;
            }
            d = valueAxis.valueToJava2D(((Number)object2).doubleValue(), rectangle2D, xYPlot.getDomainAxisEdge());
            double d8 = valueAxis2.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            double d9 = valueAxis2.valueToJava2D(((Number)object).doubleValue(), rectangle2D, rectangleEdge);
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                graphics2D.draw(new Line2D.Double(d8, d, d9, d3));
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                graphics2D.draw(new Line2D.Double(d, d8, d3, d9));
            }
        }
        if (entityCollection != null) {
            object2 = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                object2 = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            object = null;
            if (this.getURLGenerator() != null) {
                object = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, (String)object2, (String)object);
            entityCollection.add(xYItemEntity);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

