/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.xy;

import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CrosshairState;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYItemRendererState;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.util.PublicCloneable;

public class ClusteredXYBarRenderer
extends XYBarRenderer
implements Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 5864462149177133147L;
    private boolean centerBarAtStartValue;

    public ClusteredXYBarRenderer() {
        this(0.0, false);
    }

    public ClusteredXYBarRenderer(double d, boolean bl) {
        super(d);
        this.centerBarAtStartValue = bl;
    }

    public void drawItem(Graphics2D graphics2D, XYItemRendererState xYItemRendererState, Rectangle2D rectangle2D, PlotRenderingInfo plotRenderingInfo, XYPlot xYPlot, ValueAxis valueAxis, ValueAxis valueAxis2, XYDataset xYDataset, int n, int n2, CrosshairState crosshairState, int n3) {
        EntityCollection entityCollection;
        double d;
        double d2;
        IntervalXYDataset intervalXYDataset = (IntervalXYDataset)xYDataset;
        Paint paint = this.getItemPaint(n, n2);
        if (this.getUseYInterval()) {
            d2 = intervalXYDataset.getStartYValue(n, n2);
            d = intervalXYDataset.getEndYValue(n, n2);
        } else {
            d2 = this.getBase();
            d = intervalXYDataset.getYValue(n, n2);
        }
        if (Double.isNaN(d2) || Double.isNaN(d)) {
            return;
        }
        double d3 = valueAxis2.valueToJava2D(d2, rectangle2D, xYPlot.getRangeAxisEdge());
        double d4 = valueAxis2.valueToJava2D(d, rectangle2D, xYPlot.getRangeAxisEdge());
        RectangleEdge rectangleEdge = xYPlot.getDomainAxisEdge();
        double d5 = intervalXYDataset.getStartXValue(n, n2);
        double d6 = valueAxis.valueToJava2D(d5, rectangle2D, rectangleEdge);
        double d7 = intervalXYDataset.getEndXValue(n, n2);
        double d8 = valueAxis.valueToJava2D(d7, rectangle2D, rectangleEdge);
        double d9 = Math.max(1.0, Math.abs(d8 - d6));
        double d10 = Math.abs(d3 - d4);
        if (this.centerBarAtStartValue) {
            d6 -= d9 / 2.0;
        }
        if (this.getMargin() > 0.0) {
            double d11 = d9 * this.getMargin();
            d9 -= d11;
            d6 += d11 / 2.0;
        }
        int n4 = xYDataset.getSeriesCount();
        double d12 = d9 / (double)n4;
        Rectangle2D.Double double_ = null;
        PlotOrientation plotOrientation = xYPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            double_ = new Rectangle2D.Double(Math.min(d3, d4), d6 - d12 * (double)(n4 - n), d10, d12);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            double_ = new Rectangle2D.Double(d6 + d12 * (double)n, Math.min(d3, d4), d12, d10);
        }
        graphics2D.setPaint(paint);
        graphics2D.fill(double_);
        if (this.isDrawBarOutline() && Math.abs(d8 - d6) > 3.0) {
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_);
        }
        if (this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, plotOrientation, xYDataset, n, n2, double_.getCenterX(), ((RectangularShape)double_).getY(), d < 0.0);
        }
        if (plotRenderingInfo != null && (entityCollection = plotRenderingInfo.getOwner().getEntityCollection()) != null) {
            String string = null;
            XYToolTipGenerator xYToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (xYToolTipGenerator != null) {
                string = xYToolTipGenerator.generateToolTip(xYDataset, n, n2);
            }
            String string2 = null;
            if (this.getURLGenerator() != null) {
                string2 = this.getURLGenerator().generateURL(xYDataset, n, n2);
            }
            XYItemEntity xYItemEntity = new XYItemEntity(double_, xYDataset, n, n2, string, string2);
            entityCollection.add(xYItemEntity);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ClusteredXYBarRenderer)) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        ClusteredXYBarRenderer clusteredXYBarRenderer = (ClusteredXYBarRenderer)object;
        return this.centerBarAtStartValue == clusteredXYBarRenderer.centerBarAtStartValue;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

