/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;

public class GroupedStackedBarRendererTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(GroupedStackedBarRendererTests.class);
    }

    public GroupedStackedBarRendererTests(String string) {
        super(string);
    }

    public void testEquals() {
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer groupedStackedBarRenderer2 = new GroupedStackedBarRenderer();
        GroupedStackedBarRendererTests.assertTrue((boolean)groupedStackedBarRenderer.equals(groupedStackedBarRenderer2));
        GroupedStackedBarRendererTests.assertTrue((boolean)groupedStackedBarRenderer2.equals(groupedStackedBarRenderer));
        KeyToGroupMap keyToGroupMap = new KeyToGroupMap((Comparable)((Object)"G1"));
        keyToGroupMap.mapKeyToGroup((Comparable)((Object)"S1"), (Comparable)((Object)"G2"));
        groupedStackedBarRenderer.setSeriesToGroupMap(keyToGroupMap);
        GroupedStackedBarRendererTests.assertFalse((boolean)groupedStackedBarRenderer.equals(groupedStackedBarRenderer2));
        KeyToGroupMap keyToGroupMap2 = new KeyToGroupMap((Comparable)((Object)"G1"));
        keyToGroupMap2.mapKeyToGroup((Comparable)((Object)"S1"), (Comparable)((Object)"G2"));
        groupedStackedBarRenderer2.setSeriesToGroupMap(keyToGroupMap2);
        GroupedStackedBarRendererTests.assertTrue((boolean)groupedStackedBarRenderer.equals(groupedStackedBarRenderer2));
    }

    public void testCloning() {
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer groupedStackedBarRenderer2 = null;
        try {
            groupedStackedBarRenderer2 = (GroupedStackedBarRenderer)groupedStackedBarRenderer.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        GroupedStackedBarRendererTests.assertTrue((groupedStackedBarRenderer != groupedStackedBarRenderer2 ? 1 : 0) != 0);
        GroupedStackedBarRendererTests.assertTrue((groupedStackedBarRenderer.getClass() == groupedStackedBarRenderer2.getClass() ? 1 : 0) != 0);
        GroupedStackedBarRendererTests.assertTrue((boolean)groupedStackedBarRenderer.equals(groupedStackedBarRenderer2));
    }

    public void testSerialization() {
        GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
        GroupedStackedBarRenderer groupedStackedBarRenderer2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(groupedStackedBarRenderer);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            groupedStackedBarRenderer2 = (GroupedStackedBarRenderer)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        GroupedStackedBarRendererTests.assertEquals((Object)groupedStackedBarRenderer, groupedStackedBarRenderer2);
    }
}

