/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.Icon;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.AbstractCategoryItemRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.io.SerialUtilities;

public class MinMaxCategoryRenderer
extends AbstractCategoryItemRenderer {
    private static final long serialVersionUID = 2935615937671064911L;
    private boolean plotLines = false;
    private transient Paint groupPaint = Color.black;
    private transient Stroke groupStroke = new BasicStroke(1.0f);
    private transient Icon minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
    private transient Icon objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    private int lastCategory = -1;
    private double min;
    private double max;
    private Number minValue;
    private Number maxValue;

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        Number number = categoryDataset.getValue(n, n2);
        if (number != null) {
            Object object;
            double d = categoryAxis.getCategoryMiddle(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
            double d2 = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, categoryPlot.getRangeAxisEdge());
            graphics2D.setPaint(this.getItemPaint(n, n2));
            graphics2D.setStroke(this.getItemStroke(n, n2));
            Rectangle2D.Double double_ = null;
            double_ = new Rectangle2D.Double(d - 4.0, d2 - 4.0, 8.0, 8.0);
            this.objectIcon.paintIcon(null, graphics2D, (int)d, (int)d2);
            if (this.lastCategory == n2) {
                if (this.minValue.doubleValue() > number.doubleValue()) {
                    this.min = d2;
                    this.minValue = number;
                }
                if (this.maxValue.doubleValue() < number.doubleValue()) {
                    this.max = d2;
                    this.maxValue = number;
                }
                if (categoryDataset.getRowCount() - 1 == n) {
                    graphics2D.setPaint(this.groupPaint);
                    graphics2D.setStroke(this.groupStroke);
                    graphics2D.draw(new Line2D.Double(d, this.min, d, this.max));
                    this.minIcon.paintIcon(null, graphics2D, (int)d, (int)this.min);
                    this.maxIcon.paintIcon(null, graphics2D, (int)d, (int)this.max);
                }
            } else {
                this.lastCategory = n2;
                this.min = d2;
                this.max = d2;
                this.minValue = number;
                this.maxValue = number;
            }
            if (this.plotLines && n2 != 0 && (object = categoryDataset.getValue(n, n2 - 1)) != null) {
                double d3 = ((Number)object).doubleValue();
                double d4 = categoryAxis.getCategoryStart(n2 - 1, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge());
                double d5 = valueAxis.valueToJava2D(d3, rectangle2D, categoryPlot.getRangeAxisEdge());
                graphics2D.setPaint(this.getItemPaint(n, n2));
                graphics2D.setStroke(this.getItemStroke(n, n2));
                Line2D.Double double_2 = new Line2D.Double(d4, d5, d, d2);
                graphics2D.draw(double_2);
            }
            if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null && double_ != null) {
                String string = null;
                CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (categoryToolTipGenerator != null) {
                    string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, null, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
                object.add(categoryItemEntity);
            }
        }
    }

    public void setDrawLines(boolean bl) {
        this.plotLines = bl;
    }

    public boolean isDrawLines() {
        return this.plotLines;
    }

    public void setGroupPaint(Paint paint) {
        this.groupPaint = paint;
    }

    public Paint getGroupPaint() {
        return this.groupPaint;
    }

    public void setGroupStroke(Stroke stroke) {
        this.groupStroke = stroke;
    }

    public Stroke getGroupStroke() {
        return this.groupStroke;
    }

    public void setObjectIcon(Icon icon) {
        this.objectIcon = icon;
    }

    public Icon getObjectIcon() {
        return this.objectIcon;
    }

    public void setMaxIcon(Icon icon) {
        this.maxIcon = icon;
    }

    public Icon getMaxIcone() {
        return this.maxIcon;
    }

    public void setMinIcon(Icon icon) {
        this.minIcon = icon;
    }

    public Icon getMinIcon() {
        return this.minIcon;
    }

    private Icon getIcon(Shape shape, final Paint paint, final Paint paint2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (paint != null) {
                    graphics2D.setPaint(paint);
                    graphics2D.fill(generalPath);
                }
                if (paint2 != null) {
                    graphics2D.setPaint(paint2);
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private Icon getIcon(Shape shape, final boolean bl, final boolean bl2) {
        final int n = shape.getBounds().width;
        final int n2 = shape.getBounds().height;
        final GeneralPath generalPath = new GeneralPath(shape);
        return new Icon(){

            public void paintIcon(Component component, Graphics graphics, int n3, int n22) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                generalPath.transform(AffineTransform.getTranslateInstance(n3, n22));
                if (bl) {
                    graphics2D.fill(generalPath);
                }
                if (bl2) {
                    graphics2D.draw(generalPath);
                }
                generalPath.transform(AffineTransform.getTranslateInstance(-n3, -n22));
            }

            public int getIconWidth() {
                return n;
            }

            public int getIconHeight() {
                return n2;
            }
        };
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writeStroke(this.groupStroke, objectOutputStream);
        SerialUtilities.writePaint(this.groupPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.groupStroke = SerialUtilities.readStroke(objectInputStream);
        this.groupPaint = SerialUtilities.readPaint(objectInputStream);
        this.minIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.maxIcon = this.getIcon((Shape)new Arc2D.Double(-4.0, -4.0, 8.0, 8.0, 0.0, 360.0, 0), null, Color.black);
        this.objectIcon = this.getIcon((Shape)new Line2D.Double(-4.0, 0.0, 4.0, 0.0), false, true);
    }
}

