/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.renderer.category;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.jfree.chart.Effect3D;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.entity.EntityCollection;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.io.SerialUtilities;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.TextAnchor;
import org.jfree.util.PublicCloneable;

public class BarRenderer3D
extends BarRenderer
implements Effect3D,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 7686976503536003636L;
    public static final double DEFAULT_X_OFFSET = 12.0;
    public static final double DEFAULT_Y_OFFSET = 8.0;
    public static final Paint DEFAULT_WALL_PAINT = new Color(221, 221, 221);
    private double xOffset;
    private double yOffset;
    private transient Paint wallPaint;

    public BarRenderer3D() {
        this(12.0, 8.0);
    }

    public BarRenderer3D(double d, double d2) {
        this.xOffset = d;
        this.yOffset = d2;
        this.wallPaint = DEFAULT_WALL_PAINT;
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.TOP_CENTER);
        this.setPositiveItemLabelPosition(itemLabelPosition);
        ItemLabelPosition itemLabelPosition2 = new ItemLabelPosition(ItemLabelAnchor.INSIDE12, TextAnchor.TOP_CENTER);
        this.setNegativeItemLabelPosition(itemLabelPosition2);
    }

    public double getXOffset() {
        return this.xOffset;
    }

    public double getYOffset() {
        return this.yOffset;
    }

    public Paint getWallPaint() {
        return this.wallPaint;
    }

    public void setWallPaint(Paint paint) {
        this.wallPaint = paint;
    }

    public CategoryItemRendererState initialise(Graphics2D graphics2D, Rectangle2D rectangle2D, CategoryPlot categoryPlot, int n, PlotRenderingInfo plotRenderingInfo) {
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        CategoryItemRendererState categoryItemRendererState = super.initialise(graphics2D, double_, categoryPlot, n, plotRenderingInfo);
        return categoryItemRendererState;
    }

    public void drawBackground(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Paint paint = categoryPlot.getBackgroundPaint();
        if (paint != null) {
            graphics2D.setPaint(paint);
            graphics2D.fill(generalPath);
        }
        GeneralPath generalPath2 = new GeneralPath();
        generalPath2.moveTo(f, f5);
        generalPath2.lineTo(f, f8);
        generalPath2.lineTo(f2, f7);
        generalPath2.lineTo(f2, f6);
        generalPath2.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath2);
        GeneralPath generalPath3 = new GeneralPath();
        generalPath3.moveTo(f, f5);
        generalPath3.lineTo(f2, f6);
        generalPath3.lineTo(f3, f6);
        generalPath3.lineTo(f4, f5);
        generalPath3.closePath();
        graphics2D.setPaint(this.getWallPaint());
        graphics2D.fill(generalPath3);
        graphics2D.setPaint(Color.lightGray);
        Line2D.Double double_ = new Line2D.Double(f, f5, f2, f6);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f2, f7);
        graphics2D.draw(double_);
        ((Line2D)double_).setLine(f2, f6, f3, f6);
        graphics2D.draw(double_);
        Image image = categoryPlot.getBackgroundImage();
        if (image != null) {
            Composite composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(2, categoryPlot.getBackgroundAlpha()));
            graphics2D.drawImage(image, (int)f2, (int)f7, (int)(f3 - f2 + 1.0f), (int)(f6 - f7 + 1.0f), null);
            graphics2D.setComposite(composite);
        }
    }

    public void drawOutline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D) {
        float f = (float)rectangle2D.getX();
        float f2 = f + (float)Math.abs(this.xOffset);
        float f3 = (float)rectangle2D.getMaxX();
        float f4 = f3 - (float)Math.abs(this.xOffset);
        float f5 = (float)rectangle2D.getMaxY();
        float f6 = f5 - (float)Math.abs(this.yOffset);
        float f7 = (float)rectangle2D.getMinY();
        float f8 = f7 + (float)Math.abs(this.yOffset);
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo(f, f5);
        generalPath.lineTo(f, f8);
        generalPath.lineTo(f2, f7);
        generalPath.lineTo(f3, f7);
        generalPath.lineTo(f3, f6);
        generalPath.lineTo(f4, f5);
        generalPath.closePath();
        Stroke stroke = categoryPlot.getOutlineStroke();
        Paint paint = categoryPlot.getOutlinePaint();
        if (stroke != null && paint != null) {
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint);
            graphics2D.draw(generalPath);
        }
    }

    public void drawDomainGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, Rectangle2D rectangle2D, double d) {
        double d2;
        Line2D.Double double_ = null;
        Line2D.Double double_2 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = d;
            double d3 = d - this.getYOffset();
            double d4 = rectangle2D.getMinX();
            double d5 = d4 + this.getXOffset();
            double d6 = rectangle2D.getMaxY();
            double_ = new Line2D.Double(d4, d2, d5, d3);
            double_2 = new Line2D.Double(d5, d3, d6, d3);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = d;
            double d7 = d + this.getXOffset();
            double d8 = rectangle2D.getMaxY();
            double d9 = d8 - this.getYOffset();
            double d10 = rectangle2D.getMinY();
            double_ = new Line2D.Double(d2, d8, d7, d9);
            double_2 = new Line2D.Double(d7, d9, d7, d10);
        }
        Paint paint = categoryPlot.getDomainGridlinePaint();
        Stroke stroke = categoryPlot.getDomainGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_);
        graphics2D.draw(double_2);
    }

    public void drawRangeGridline(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Rectangle2D rectangle2D, double d) {
        double d2;
        Range range = valueAxis.getRange();
        if (!range.contains(d)) {
            return;
        }
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        Line2D.Double double_2 = null;
        Line2D.Double double_3 = null;
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        if (plotOrientation == PlotOrientation.HORIZONTAL) {
            d2 = valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d3 = d2 + this.getXOffset();
            double d4 = rectangle2D.getMaxY();
            double d5 = d4 - this.getYOffset();
            double d6 = rectangle2D.getMinY();
            double_2 = new Line2D.Double(d2, d4, d3, d5);
            double_3 = new Line2D.Double(d3, d5, d3, d6);
        } else if (plotOrientation == PlotOrientation.VERTICAL) {
            d2 = valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
            double d7 = d2 - this.getYOffset();
            double d8 = rectangle2D.getMinX();
            double d9 = d8 + this.getXOffset();
            double d10 = rectangle2D.getMaxX();
            double_2 = new Line2D.Double(d8, d2, d9, d7);
            double_3 = new Line2D.Double(d9, d7, d10, d7);
        }
        Paint paint = categoryPlot.getRangeGridlinePaint();
        Stroke stroke = categoryPlot.getRangeGridlineStroke();
        graphics2D.setPaint(paint != null ? paint : Plot.DEFAULT_OUTLINE_PAINT);
        graphics2D.setStroke(stroke != null ? stroke : Plot.DEFAULT_OUTLINE_STROKE);
        graphics2D.draw(double_2);
        graphics2D.draw(double_3);
    }

    public void drawRangeMarker(Graphics2D graphics2D, CategoryPlot categoryPlot, ValueAxis valueAxis, Marker marker, Rectangle2D rectangle2D) {
        if (marker instanceof ValueMarker) {
            ValueMarker valueMarker = (ValueMarker)marker;
            double d = valueMarker.getValue();
            Range range = valueAxis.getRange();
            if (!range.contains(d)) {
                return;
            }
            Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
            GeneralPath generalPath = null;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                float f = (float)valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
                float f2 = (float)double_.getMaxY();
                generalPath = new GeneralPath();
                generalPath.moveTo(f, f2);
                generalPath.lineTo((float)((double)f + this.getXOffset()), f2 - (float)this.getYOffset());
                generalPath.lineTo((float)((double)f + this.getXOffset()), (float)(double_.getMinY() - this.getYOffset()));
                generalPath.lineTo(f, (float)double_.getMinY());
                generalPath.closePath();
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                float f = (float)valueAxis.valueToJava2D(d, double_, categoryPlot.getRangeAxisEdge());
                float f3 = (float)rectangle2D.getX();
                generalPath = new GeneralPath();
                generalPath.moveTo(f3, f);
                generalPath.lineTo(f3 + (float)this.xOffset, f - (float)this.yOffset);
                generalPath.lineTo((float)(double_.getMaxX() + this.xOffset), f - (float)this.yOffset);
                generalPath.lineTo((float)double_.getMaxX(), f);
                generalPath.closePath();
            }
            graphics2D.setPaint(marker.getPaint());
            graphics2D.fill(generalPath);
            graphics2D.setPaint(marker.getOutlinePaint());
            graphics2D.draw(generalPath);
        } else {
            super.drawRangeMarker(graphics2D, categoryPlot, valueAxis, marker, rectangle2D);
        }
    }

    public void drawItem(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, CategoryDataset categoryDataset, int n, int n2, int n3) {
        EntityCollection entityCollection;
        CategoryItemLabelGenerator categoryItemLabelGenerator;
        Number number = categoryDataset.getValue(n, n2);
        if (number == null) {
            return;
        }
        double d = number.doubleValue();
        Rectangle2D.Double double_ = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY() + this.getYOffset(), rectangle2D.getWidth() - this.getXOffset(), rectangle2D.getHeight() - this.getYOffset());
        PlotOrientation plotOrientation = categoryPlot.getOrientation();
        double d2 = this.calculateBarW0(categoryPlot, plotOrientation, double_, categoryAxis, categoryItemRendererState, n, n2);
        double[] dArray = this.calculateBarL0L1(d);
        if (dArray == null) {
            return;
        }
        RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
        double d3 = valueAxis.valueToJava2D(dArray[0], double_, rectangleEdge);
        double d4 = valueAxis.valueToJava2D(dArray[1], double_, rectangleEdge);
        double d5 = Math.min(d3, d4);
        double d6 = Math.abs(d4 - d3);
        Rectangle2D.Double double_2 = null;
        double_2 = plotOrientation == PlotOrientation.HORIZONTAL ? new Rectangle2D.Double(d5, d2, d6, categoryItemRendererState.getBarWidth()) : new Rectangle2D.Double(d2, d5, categoryItemRendererState.getBarWidth(), d6);
        Paint paint = this.getItemPaint(n, n2);
        graphics2D.setPaint(paint);
        graphics2D.fill(double_2);
        double d7 = double_2.getMinX();
        double d8 = d7 + this.getXOffset();
        double d9 = double_2.getMaxX();
        double d10 = d9 + this.getXOffset();
        double d11 = double_2.getMinY() - this.getYOffset();
        double d12 = double_2.getMinY();
        double d13 = double_2.getMaxY() - this.getYOffset();
        double d14 = double_2.getMaxY();
        GeneralPath generalPath = null;
        GeneralPath generalPath2 = null;
        if (d6 > 0.0) {
            generalPath = new GeneralPath();
            generalPath.moveTo((float)d9, (float)d14);
            generalPath.lineTo((float)d9, (float)d12);
            generalPath.lineTo((float)d10, (float)d11);
            generalPath.lineTo((float)d10, (float)d13);
            generalPath.closePath();
            if (paint instanceof Color) {
                graphics2D.setPaint(((Color)paint).darker());
            }
            graphics2D.fill(generalPath);
        }
        generalPath2 = new GeneralPath();
        generalPath2.moveTo((float)d7, (float)d12);
        generalPath2.lineTo((float)d8, (float)d11);
        generalPath2.lineTo((float)d10, (float)d11);
        generalPath2.lineTo((float)d9, (float)d12);
        generalPath2.closePath();
        graphics2D.fill(generalPath2);
        if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
            graphics2D.setStroke(this.getItemOutlineStroke(n, n2));
            graphics2D.setPaint(this.getItemOutlinePaint(n, n2));
            graphics2D.draw(double_2);
            if (generalPath != null) {
                graphics2D.draw(generalPath);
            }
            if (generalPath2 != null) {
                graphics2D.draw(generalPath2);
            }
        }
        if ((categoryItemLabelGenerator = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
            this.drawItemLabel(graphics2D, categoryDataset, n, n2, categoryPlot, categoryItemLabelGenerator, double_2, d < 0.0);
        }
        if (categoryItemRendererState.getInfo() != null && (entityCollection = categoryItemRendererState.getInfo().getOwner().getEntityCollection()) != null) {
            GeneralPath generalPath3 = new GeneralPath();
            generalPath3.moveTo((float)d7, (float)d14);
            generalPath3.lineTo((float)d7, (float)d12);
            generalPath3.lineTo((float)d8, (float)d11);
            generalPath3.lineTo((float)d10, (float)d11);
            generalPath3.lineTo((float)d10, (float)d13);
            generalPath3.lineTo((float)d9, (float)d14);
            generalPath3.closePath();
            String string = null;
            CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
            if (categoryToolTipGenerator != null) {
                string = categoryToolTipGenerator.generateToolTip(categoryDataset, n, n2);
            }
            String string2 = null;
            if (this.getItemURLGenerator(n, n2) != null) {
                string2 = this.getItemURLGenerator(n, n2).generateURL(categoryDataset, n, n2);
            }
            CategoryItemEntity categoryItemEntity = new CategoryItemEntity(generalPath3, string, string2, categoryDataset, n, categoryDataset.getColumnKey(n2), n2);
            entityCollection.add(categoryItemEntity);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        SerialUtilities.writePaint(this.wallPaint, objectOutputStream);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.wallPaint = SerialUtilities.readPaint(objectInputStream);
    }
}

