/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.junit.MyPlotChangeListener;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.AbstractDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;

public class XYPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYPlotTests.class);
    }

    public XYPlotTests(String string) {
        super(string);
    }

    public void testGetDatasetCount() {
        XYPlot xYPlot = new XYPlot();
        XYPlotTests.assertEquals((int)0, (int)xYPlot.getDatasetCount());
    }

    public void testEquals() {
        XYPlot xYPlot = new XYPlot();
        XYPlot xYPlot2 = new XYPlot();
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setOrientation(PlotOrientation.HORIZONTAL);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setOrientation(PlotOrientation.HORIZONTAL);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainAxis(new NumberAxis("Domain Axis"));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainAxis(new NumberAxis("Domain Axis"));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainAxis(11, new NumberAxis("Secondary Domain Axis"));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeAxis(new NumberAxis("Range Axis"));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeAxis(new NumberAxis("Range Axis"));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.mapDatasetToDomainAxis(11, 11);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.mapDatasetToDomainAxis(11, 11);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.mapDatasetToRangeAxis(11, 11);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.mapDatasetToRangeAxis(11, 11);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRenderer(new DefaultXYItemRenderer());
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRenderer(new DefaultXYItemRenderer());
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRenderer(11, new DefaultXYItemRenderer());
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRenderer(11, new DefaultXYItemRenderer());
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainGridlinesVisible(false);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainGridlinesVisible(false);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        xYPlot.setDomainGridlineStroke(basicStroke);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainGridlineStroke(basicStroke);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainGridlinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainGridlinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeGridlinesVisible(false);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeGridlinesVisible(false);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeGridlineStroke(basicStroke);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeGridlineStroke(basicStroke);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeGridlinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeGridlinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeZeroBaselineVisible(true);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeZeroBaselineVisible(true);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeZeroBaselineStroke(basicStroke);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeZeroBaselineStroke(basicStroke);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeZeroBaselinePaint(Color.blue);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeZeroBaselinePaint(Color.blue);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeCrosshairVisible(true);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeCrosshairVisible(true);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeCrosshairValue(100.0);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeCrosshairValue(100.0);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeCrosshairStroke(basicStroke);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeCrosshairStroke(basicStroke);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeCrosshairPaint(Color.red);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeCrosshairPaint(Color.red);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeCrosshairLockedOnData(false);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeCrosshairLockedOnData(false);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.addRangeMarker(new ValueMarker(4.0));
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.addRangeMarker(new ValueMarker(4.0));
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.addRangeMarker(1, new ValueMarker(99.0), Layer.BACKGROUND);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.addRangeMarker(1, new ValueMarker(99.0), Layer.BACKGROUND);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setWeight(3);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setWeight(3);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
    }

    public void testCloning() {
        XYPlot xYPlot = new XYPlot();
        XYPlot xYPlot2 = null;
        try {
            xYPlot2 = (XYPlot)xYPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("XYPlotTests.testCloning: failed to clone.");
        }
        XYPlotTests.assertTrue((xYPlot != xYPlot2 ? 1 : 0) != 0);
        XYPlotTests.assertTrue((xYPlot.getClass() == xYPlot2.getClass() ? 1 : 0) != 0);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
    }

    public void testCloning2() {
        XYPlot xYPlot = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        xYPlot.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        xYPlot.setRenderer(1, new XYBarRenderer());
        XYPlot xYPlot2 = null;
        try {
            xYPlot2 = (XYPlot)xYPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        XYPlotTests.assertTrue((xYPlot != xYPlot2 ? 1 : 0) != 0);
        XYPlotTests.assertTrue((xYPlot.getClass() == xYPlot2.getClass() ? 1 : 0) != 0);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
    }

    public void testCloneIndependence() {
        XYPlot xYPlot = new XYPlot(null, new NumberAxis("Domain Axis"), new NumberAxis("Range Axis"), new StandardXYItemRenderer());
        xYPlot.setDomainAxis(1, new NumberAxis("Domain Axis 2"));
        xYPlot.setDomainAxisLocation(1, AxisLocation.BOTTOM_OR_LEFT);
        xYPlot.setRangeAxis(1, new NumberAxis("Range Axis 2"));
        xYPlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        xYPlot.setRenderer(1, new XYBarRenderer());
        XYPlot xYPlot2 = null;
        try {
            xYPlot2 = (XYPlot)xYPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getDomainAxis().setLabel("Label");
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getDomainAxis().setLabel("Label");
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getDomainAxis(1).setLabel("S1");
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getDomainAxis(1).setLabel("S1");
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setDomainAxisLocation(1, AxisLocation.TOP_OR_RIGHT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.mapDatasetToDomainAxis(2, 1);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.mapDatasetToDomainAxis(2, 1);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getRangeAxis().setLabel("Label");
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getRangeAxis().setLabel("Label");
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getRangeAxis(1).setLabel("S1");
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getRangeAxis(1).setLabel("S1");
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.setRangeAxisLocation(1, AxisLocation.TOP_OR_LEFT);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.mapDatasetToRangeAxis(2, 1);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.mapDatasetToRangeAxis(2, 1);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getRenderer().setOutlinePaint(Color.cyan);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getRenderer().setOutlinePaint(Color.cyan);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
        xYPlot.getRenderer(1).setOutlinePaint(Color.red);
        XYPlotTests.assertFalse((boolean)xYPlot.equals(xYPlot2));
        xYPlot2.getRenderer(1).setOutlinePaint(Color.red);
        XYPlotTests.assertTrue((boolean)xYPlot.equals(xYPlot2));
    }

    public void testSetNullRenderer() {
        boolean bl = false;
        try {
            XYPlot xYPlot = new XYPlot(null, new NumberAxis("X"), new NumberAxis("Y"), null);
            xYPlot.setRenderer(null);
        }
        catch (Exception exception) {
            bl = true;
        }
        XYPlotTests.assertTrue((!bl ? 1 : 0) != 0);
    }

    public void testSerialization1() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        NumberAxis numberAxis = new NumberAxis("Domain");
        NumberAxis numberAxis2 = new NumberAxis("Range");
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYPlot xYPlot = new XYPlot(xYSeriesCollection, numberAxis, numberAxis2, standardXYItemRenderer);
        XYPlot xYPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYPlot2 = (XYPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            XYPlotTests.fail((String)exception.toString());
        }
        XYPlotTests.assertEquals((Object)xYPlot, xYPlot2);
    }

    public void testSerialization2() {
        IntervalXYDataset intervalXYDataset = this.createDataset1();
        XYBarRenderer xYBarRenderer = new XYBarRenderer(0.2);
        xYBarRenderer.setToolTipGenerator(StandardXYToolTipGenerator.getTimeSeriesInstance());
        XYPlot xYPlot = new XYPlot(intervalXYDataset, new DateAxis("Date"), null, xYBarRenderer);
        XYPlot xYPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYPlot2 = (XYPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            XYPlotTests.fail((String)exception.toString());
        }
        XYPlotTests.assertEquals((Object)xYPlot, xYPlot2);
    }

    public void testSerialization3() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Test Chart", "Domain Axis", "Range Axis", xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            XYPlotTests.fail((String)exception.toString());
        }
        boolean bl = jFreeChart.equals(jFreeChart2);
        System.out.println(bl);
        XYPlotTests.assertEquals((Object)jFreeChart, jFreeChart2);
        boolean bl2 = true;
        try {
            jFreeChart2.createBufferedImage(300, 200);
        }
        catch (Exception exception) {
            bl2 = false;
            exception.printStackTrace();
        }
        XYPlotTests.assertTrue((boolean)bl2);
    }

    public void testSerialization4() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Test Chart", "Domain Axis", "Range Axis", xYSeriesCollection, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.addDomainMarker(new ValueMarker(1.0), Layer.FOREGROUND);
        xYPlot.addDomainMarker(new IntervalMarker(2.0, 3.0), Layer.BACKGROUND);
        xYPlot.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        xYPlot.addRangeMarker(new IntervalMarker(5.0, 6.0), Layer.BACKGROUND);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            XYPlotTests.fail((String)exception.toString());
        }
        XYPlotTests.assertEquals((Object)jFreeChart, jFreeChart2);
        boolean bl = true;
        try {
            jFreeChart2.createBufferedImage(300, 200);
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        XYPlotTests.assertTrue((boolean)bl);
    }

    public void testSerialization5() {
        Object object;
        Object object2;
        Object object3;
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        NumberAxis numberAxis = new NumberAxis("Domain 1");
        NumberAxis numberAxis2 = new NumberAxis("Range 1");
        StandardXYItemRenderer standardXYItemRenderer = new StandardXYItemRenderer();
        XYPlot xYPlot = new XYPlot(xYSeriesCollection, numberAxis, numberAxis2, standardXYItemRenderer);
        NumberAxis numberAxis3 = new NumberAxis("Domain 2");
        NumberAxis numberAxis4 = new NumberAxis("Range 2");
        StandardXYItemRenderer standardXYItemRenderer2 = new StandardXYItemRenderer();
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        xYPlot.setDataset(1, xYSeriesCollection2);
        xYPlot.setDomainAxis(1, numberAxis3);
        xYPlot.setRangeAxis(1, numberAxis4);
        xYPlot.setRenderer(1, standardXYItemRenderer2);
        XYPlot xYPlot2 = null;
        try {
            object3 = new ByteArrayOutputStream();
            object2 = new ObjectOutputStream((OutputStream)object3);
            object2.writeObject(xYPlot);
            object2.close();
            object = new ObjectInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray()));
            xYPlot2 = (XYPlot)object.readObject();
            object.close();
        }
        catch (Exception exception) {
            XYPlotTests.fail((String)exception.toString());
        }
        XYPlotTests.assertEquals((Object)xYPlot, xYPlot2);
        object3 = (NumberAxis)xYPlot2.getDomainAxis(0);
        object2 = (NumberAxis)xYPlot2.getRangeAxis(0);
        object = (XYSeriesCollection)xYPlot2.getDataset(0);
        StandardXYItemRenderer standardXYItemRenderer3 = (StandardXYItemRenderer)xYPlot2.getRenderer(0);
        NumberAxis numberAxis5 = (NumberAxis)xYPlot2.getDomainAxis(1);
        NumberAxis numberAxis6 = (NumberAxis)xYPlot2.getRangeAxis(1);
        XYSeriesCollection xYSeriesCollection3 = (XYSeriesCollection)xYPlot2.getDataset(1);
        StandardXYItemRenderer standardXYItemRenderer4 = (StandardXYItemRenderer)xYPlot2.getRenderer(1);
        XYPlotTests.assertTrue((boolean)((AbstractDataset)object).hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)((Axis)object3).hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)((Axis)object2).hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)standardXYItemRenderer3.hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)xYSeriesCollection3.hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)numberAxis5.hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)numberAxis6.hasListener(xYPlot2));
        XYPlotTests.assertTrue((boolean)standardXYItemRenderer4.hasListener(xYPlot2));
    }

    public void testGetRendererForDataset() {
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        XYSeriesCollection xYSeriesCollection3 = new XYSeriesCollection();
        XYSeriesCollection xYSeriesCollection4 = new XYSeriesCollection();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer xYLineAndShapeRenderer2 = new XYLineAndShapeRenderer();
        XYPlot xYPlot = new XYPlot();
        xYPlot.setDataset(0, xYSeriesCollection);
        xYPlot.setDataset(1, xYSeriesCollection2);
        xYPlot.setDataset(2, xYSeriesCollection3);
        xYPlot.setRenderer(0, xYLineAndShapeRenderer);
        xYPlot.setRenderer(2, xYLineAndShapeRenderer2);
        XYPlotTests.assertEquals((Object)xYLineAndShapeRenderer, (Object)xYPlot.getRendererForDataset(xYSeriesCollection));
        XYPlotTests.assertEquals((Object)xYLineAndShapeRenderer, (Object)xYPlot.getRendererForDataset(xYSeriesCollection2));
        XYPlotTests.assertEquals((Object)xYLineAndShapeRenderer2, (Object)xYPlot.getRendererForDataset(xYSeriesCollection3));
        XYPlotTests.assertEquals(null, (Object)xYPlot.getRendererForDataset(xYSeriesCollection4));
        XYPlotTests.assertEquals(null, (Object)xYPlot.getRendererForDataset(null));
    }

    public void testGetLegendItems() {
        IntervalXYDataset intervalXYDataset = this.createDataset1();
        XYDataset xYDataset = this.createDataset2();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        XYPlot xYPlot = new XYPlot();
        xYPlot.setDataset(0, intervalXYDataset);
        xYPlot.setDataset(1, xYDataset);
        xYPlot.setRenderer(0, xYLineAndShapeRenderer);
        LegendItemCollection legendItemCollection = xYPlot.getLegendItems();
        XYPlotTests.assertEquals((int)2, (int)legendItemCollection.getItemCount());
    }

    private IntervalXYDataset createDataset1() {
        TimeSeries timeSeries = new TimeSeries("Series 1", Day.class);
        timeSeries.add((RegularTimePeriod)new Day(1, 3, 2002), 12353.3);
        timeSeries.add((RegularTimePeriod)new Day(2, 3, 2002), 13734.4);
        timeSeries.add((RegularTimePeriod)new Day(3, 3, 2002), 14525.3);
        timeSeries.add((RegularTimePeriod)new Day(4, 3, 2002), 13984.3);
        timeSeries.add((RegularTimePeriod)new Day(5, 3, 2002), 12999.4);
        timeSeries.add((RegularTimePeriod)new Day(6, 3, 2002), 14274.3);
        timeSeries.add((RegularTimePeriod)new Day(7, 3, 2002), 15943.5);
        timeSeries.add((RegularTimePeriod)new Day(8, 3, 2002), 14845.3);
        timeSeries.add((RegularTimePeriod)new Day(9, 3, 2002), 14645.4);
        timeSeries.add((RegularTimePeriod)new Day(10, 3, 2002), 16234.6);
        timeSeries.add((RegularTimePeriod)new Day(11, 3, 2002), 17232.3);
        timeSeries.add((RegularTimePeriod)new Day(12, 3, 2002), 14232.2);
        timeSeries.add((RegularTimePeriod)new Day(13, 3, 2002), 13102.2);
        timeSeries.add((RegularTimePeriod)new Day(14, 3, 2002), 14230.2);
        timeSeries.add((RegularTimePeriod)new Day(15, 3, 2002), 11235.2);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeSeries);
        timeSeriesCollection.setDomainIsPointsInTime(false);
        return timeSeriesCollection;
    }

    private XYDataset createDataset2() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 2"));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        return xYSeriesCollection;
    }

    public void testSetRenderer() {
        XYPlot xYPlot = new XYPlot();
        XYLineAndShapeRenderer xYLineAndShapeRenderer = new XYLineAndShapeRenderer();
        xYPlot.setRenderer(xYLineAndShapeRenderer);
        MyPlotChangeListener myPlotChangeListener = new MyPlotChangeListener();
        xYPlot.addChangeListener(myPlotChangeListener);
        xYLineAndShapeRenderer.setSeriesPaint(0, Color.black);
        XYPlotTests.assertTrue((myPlotChangeListener.getEvent() != null ? 1 : 0) != 0);
    }
}

