/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.ui.LengthAdjustmentType;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class ValueMarkerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ValueMarkerTests.class);
    }

    public ValueMarkerTests(String string) {
        super(string);
    }

    public void testEquals() {
        ValueMarker valueMarker = new ValueMarker(45.0);
        ValueMarker valueMarker2 = new ValueMarker(45.0);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker2).equals(valueMarker));
        valueMarker.setPaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setPaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        BasicStroke basicStroke = new BasicStroke(2.2f);
        valueMarker.setStroke(basicStroke);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setStroke(basicStroke);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setOutlinePaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setOutlinePaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setOutlineStroke(basicStroke);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setOutlineStroke(basicStroke);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setAlpha(0.1f);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setAlpha(0.1f);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabel("New Label");
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabel("New Label");
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelFont(new Font("SansSerif", 0, 10));
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelFont(new Font("SansSerif", 0, 10));
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelPaint(Color.red);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelPaint(Color.red);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelTextAnchor(TextAnchor.BASELINE_RIGHT);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelOffset(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelOffset(new RectangleInsets(10.0, 10.0, 10.0, 10.0));
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker.setLabelOffsetType(LengthAdjustmentType.EXPAND);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2.setLabelOffsetType(LengthAdjustmentType.EXPAND);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker = new ValueMarker(12.3);
        valueMarker2 = new ValueMarker(45.6);
        ValueMarkerTests.assertFalse((boolean)((Marker)valueMarker).equals(valueMarker2));
        valueMarker2 = new ValueMarker(12.3);
        ValueMarkerTests.assertTrue((boolean)((Marker)valueMarker).equals(valueMarker2));
    }

    public void testCloning() {
        ValueMarker valueMarker = new ValueMarker(25.0);
        ValueMarker valueMarker2 = null;
        try {
            valueMarker2 = (ValueMarker)valueMarker.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        ValueMarkerTests.assertTrue((valueMarker != valueMarker2 ? 1 : 0) != 0);
        ValueMarkerTests.assertTrue((valueMarker.getClass() == valueMarker2.getClass() ? 1 : 0) != 0);
        ValueMarkerTests.assertTrue((boolean)valueMarker.equals(valueMarker2));
    }

    public void testSerialization() {
        ValueMarker valueMarker = new ValueMarker(25.0);
        ValueMarker valueMarker2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(valueMarker);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            valueMarker2 = (ValueMarker)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = valueMarker.equals(valueMarker2);
        ValueMarkerTests.assertTrue((boolean)bl);
    }
}

