/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.RingPlot;

public class RingPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(RingPlotTests.class);
    }

    public RingPlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        RingPlot ringPlot = new RingPlot(null);
        RingPlot ringPlot2 = new RingPlot(null);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
        RingPlotTests.assertTrue((boolean)ringPlot2.equals(ringPlot));
        ringPlot.setSeparatorsVisible(false);
        RingPlotTests.assertFalse((boolean)ringPlot.equals(ringPlot2));
        ringPlot2.setSeparatorsVisible(false);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
        BasicStroke basicStroke = new BasicStroke(1.1f);
        ringPlot.setSeparatorStroke(basicStroke);
        RingPlotTests.assertFalse((boolean)ringPlot.equals(ringPlot2));
        ringPlot2.setSeparatorStroke(basicStroke);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
        ringPlot.setSeparatorPaint(Color.red);
        RingPlotTests.assertFalse((boolean)ringPlot.equals(ringPlot2));
        ringPlot2.setSeparatorPaint(Color.red);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
        ringPlot.setInnerSeparatorExtension(0.01);
        RingPlotTests.assertFalse((boolean)ringPlot.equals(ringPlot2));
        ringPlot2.setInnerSeparatorExtension(0.01);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
        ringPlot.setOuterSeparatorExtension(0.02);
        RingPlotTests.assertFalse((boolean)ringPlot.equals(ringPlot2));
        ringPlot2.setOuterSeparatorExtension(0.02);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
    }

    public void testCloning() {
        RingPlot ringPlot = new RingPlot(null);
        RingPlot ringPlot2 = null;
        try {
            ringPlot2 = (RingPlot)ringPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        RingPlotTests.assertTrue((ringPlot != ringPlot2 ? 1 : 0) != 0);
        RingPlotTests.assertTrue((ringPlot.getClass() == ringPlot2.getClass() ? 1 : 0) != 0);
        RingPlotTests.assertTrue((boolean)ringPlot.equals(ringPlot2));
    }

    public void testSerialization() {
        RingPlot ringPlot = new RingPlot(null);
        RingPlot ringPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(ringPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            ringPlot2 = (RingPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        RingPlotTests.assertEquals((Object)ringPlot, ringPlot2);
    }
}

