/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.Color;
import java.awt.Font;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.DialShape;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.chart.plot.MeterPlot;
import org.jfree.data.Range;
import org.jfree.data.general.DefaultValueDataset;

public class MeterPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MeterPlotTests.class);
    }

    public MeterPlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        MeterPlot meterPlot = new MeterPlot();
        MeterPlot meterPlot2 = new MeterPlot();
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setUnits("mph");
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setUnits("mph");
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setRange(new Range(50.0, 70.0));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setRange(new Range(50.0, 70.0));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.addInterval(new MeterInterval("Normal", new Range(55.0, 60.0)));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.addInterval(new MeterInterval("Normal", new Range(55.0, 60.0)));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setDialOutlinePaint(Color.red);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setDialOutlinePaint(Color.red);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setDialShape(DialShape.CHORD);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setDialShape(DialShape.CHORD);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setDialBackgroundPaint(Color.yellow);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setDialBackgroundPaint(Color.yellow);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setNeedlePaint(Color.black);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setNeedlePaint(Color.black);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setValueFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setValueFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setValuePaint(Color.black);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setValuePaint(Color.black);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setTickLabelsVisible(false);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setTickLabelsVisible(false);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setTickLabelFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setTickLabelFont(new Font("Serif", 0, 6));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setTickLabelFormat(new DecimalFormat("0"));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setTickLabelFormat(new DecimalFormat("0"));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setDrawBorder(!meterPlot.getDrawBorder());
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setDrawBorder(meterPlot.getDrawBorder());
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.setMeterAngle(22);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.setMeterAngle(22);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
    }

    public void testCloning() {
        MeterPlot meterPlot = new MeterPlot();
        MeterPlot meterPlot2 = null;
        try {
            meterPlot2 = (MeterPlot)meterPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        MeterPlotTests.assertTrue((meterPlot != meterPlot2 ? 1 : 0) != 0);
        MeterPlotTests.assertTrue((meterPlot.getClass() == meterPlot2.getClass() ? 1 : 0) != 0);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        MeterPlotTests.assertTrue((meterPlot.getDataset() == meterPlot2.getDataset() ? 1 : 0) != 0);
        meterPlot.getTickLabelFormat().setMinimumIntegerDigits(99);
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.getTickLabelFormat().setMinimumIntegerDigits(99);
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
        meterPlot.addInterval(new MeterInterval("Test", new Range(1.234, 5.678)));
        MeterPlotTests.assertFalse((boolean)meterPlot.equals(meterPlot2));
        meterPlot2.addInterval(new MeterInterval("Test", new Range(1.234, 5.678)));
        MeterPlotTests.assertTrue((boolean)meterPlot.equals(meterPlot2));
    }

    public void testSerialization1() {
        MeterPlot meterPlot = new MeterPlot(null);
        MeterPlot meterPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(meterPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            meterPlot2 = (MeterPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        MeterPlotTests.assertEquals((Object)meterPlot, meterPlot2);
    }

    public void testSerialization2() {
        MeterPlot meterPlot = new MeterPlot(new DefaultValueDataset(1.23));
        MeterPlot meterPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(meterPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            meterPlot2 = (MeterPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        MeterPlotTests.assertEquals((Object)meterPlot, meterPlot2);
    }
}

