/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.MeterInterval;
import org.jfree.data.Range;

public class MeterIntervalTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(MeterIntervalTests.class);
    }

    public MeterIntervalTests(String string) {
        super(string);
    }

    public void testEquals() {
        MeterInterval meterInterval = new MeterInterval("Label 1", new Range(1.2, 3.4), Color.red, new BasicStroke(1.0f), Color.blue);
        MeterInterval meterInterval2 = new MeterInterval("Label 1", new Range(1.2, 3.4), Color.red, new BasicStroke(1.0f), Color.blue);
        MeterIntervalTests.assertTrue((boolean)meterInterval.equals(meterInterval2));
        MeterIntervalTests.assertTrue((boolean)meterInterval2.equals(meterInterval));
        meterInterval = new MeterInterval("Label 2", new Range(1.2, 3.4), Color.red, new BasicStroke(1.0f), Color.blue);
        MeterIntervalTests.assertFalse((boolean)meterInterval.equals(meterInterval2));
        meterInterval2 = new MeterInterval("Label 2", new Range(1.2, 3.4), Color.red, new BasicStroke(1.0f), Color.blue);
        MeterIntervalTests.assertTrue((boolean)meterInterval.equals(meterInterval2));
    }

    public void testCloning() {
        MeterInterval meterInterval = new MeterInterval("X", new Range(1.0, 2.0));
        MeterIntervalTests.assertFalse((boolean)(meterInterval instanceof Cloneable));
    }

    public void testSerialization() {
        MeterInterval meterInterval = new MeterInterval("X", new Range(1.0, 2.0));
        MeterInterval meterInterval2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(meterInterval);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            meterInterval2 = (MeterInterval)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = meterInterval.equals(meterInterval2);
        MeterIntervalTests.assertTrue((boolean)bl);
    }
}

