/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.ui.GradientPaintTransformType;
import org.jfree.ui.StandardGradientPaintTransformer;

public class IntervalMarkerTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalMarkerTests.class);
    }

    public IntervalMarkerTests(String string) {
        super(string);
    }

    public void testEquals() {
        IntervalMarker intervalMarker = new IntervalMarker(45.0, 50.0);
        IntervalMarker intervalMarker2 = new IntervalMarker(45.0, 50.0);
        IntervalMarkerTests.assertTrue((boolean)intervalMarker.equals(intervalMarker2));
        IntervalMarkerTests.assertTrue((boolean)intervalMarker2.equals(intervalMarker));
        intervalMarker = new IntervalMarker(44.0, 50.0);
        IntervalMarkerTests.assertFalse((boolean)intervalMarker.equals(intervalMarker2));
        intervalMarker2 = new IntervalMarker(44.0, 50.0);
        IntervalMarkerTests.assertTrue((boolean)intervalMarker.equals(intervalMarker2));
        intervalMarker = new IntervalMarker(44.0, 55.0);
        IntervalMarkerTests.assertFalse((boolean)intervalMarker.equals(intervalMarker2));
        intervalMarker2 = new IntervalMarker(44.0, 55.0);
        IntervalMarkerTests.assertTrue((boolean)intervalMarker.equals(intervalMarker2));
        StandardGradientPaintTransformer standardGradientPaintTransformer = new StandardGradientPaintTransformer(GradientPaintTransformType.HORIZONTAL);
        intervalMarker.setGradientPaintTransformer(standardGradientPaintTransformer);
        IntervalMarkerTests.assertFalse((boolean)intervalMarker.equals(intervalMarker2));
        intervalMarker2.setGradientPaintTransformer(standardGradientPaintTransformer);
        IntervalMarkerTests.assertTrue((boolean)intervalMarker.equals(intervalMarker2));
    }

    public void testCloning() {
        IntervalMarker intervalMarker = new IntervalMarker(45.0, 50.0);
        IntervalMarker intervalMarker2 = null;
        try {
            intervalMarker2 = (IntervalMarker)intervalMarker.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        IntervalMarkerTests.assertTrue((intervalMarker != intervalMarker2 ? 1 : 0) != 0);
        IntervalMarkerTests.assertTrue((intervalMarker.getClass() == intervalMarker2.getClass() ? 1 : 0) != 0);
        IntervalMarkerTests.assertTrue((boolean)intervalMarker.equals(intervalMarker2));
    }

    public void testSerialization() {
        IntervalMarker intervalMarker = new IntervalMarker(45.0, 50.0);
        IntervalMarker intervalMarker2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(intervalMarker);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            intervalMarker2 = (IntervalMarker)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        boolean bl = intervalMarker.equals(intervalMarker2);
        IntervalMarkerTests.assertTrue((boolean)bl);
    }
}

