/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.FastScatterPlot;

public class FastScatterPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(FastScatterPlotTests.class);
    }

    public FastScatterPlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        FastScatterPlot fastScatterPlot = new FastScatterPlot();
        FastScatterPlot fastScatterPlot2 = new FastScatterPlot();
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot2.equals(fastScatterPlot));
        fastScatterPlot.setPaint(Color.yellow);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setPaint(Color.yellow);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot.setDomainGridlinesVisible(false);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setDomainGridlinesVisible(false);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot.setDomainGridlinePaint(Color.red);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setDomainGridlinePaint(Color.red);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        BasicStroke basicStroke = new BasicStroke(1.5f);
        fastScatterPlot.setDomainGridlineStroke(basicStroke);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setDomainGridlineStroke(basicStroke);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot.setRangeGridlinesVisible(false);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setRangeGridlinesVisible(false);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot.setRangeGridlinePaint(Color.red);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setRangeGridlinePaint(Color.red);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
        BasicStroke basicStroke2 = new BasicStroke(1.5f);
        fastScatterPlot.setRangeGridlineStroke(basicStroke2);
        FastScatterPlotTests.assertFalse((boolean)fastScatterPlot.equals(fastScatterPlot2));
        fastScatterPlot2.setRangeGridlineStroke(basicStroke2);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
    }

    public void testCloning() {
        FastScatterPlot fastScatterPlot = new FastScatterPlot();
        FastScatterPlot fastScatterPlot2 = null;
        try {
            fastScatterPlot2 = (FastScatterPlot)fastScatterPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        FastScatterPlotTests.assertTrue((fastScatterPlot != fastScatterPlot2 ? 1 : 0) != 0);
        FastScatterPlotTests.assertTrue((fastScatterPlot.getClass() == fastScatterPlot2.getClass() ? 1 : 0) != 0);
        FastScatterPlotTests.assertTrue((boolean)fastScatterPlot.equals(fastScatterPlot2));
    }

    public void testSerialization() {
        float[][] fArray = this.createData();
        NumberAxis numberAxis = new NumberAxis("X");
        NumberAxis numberAxis2 = new NumberAxis("Y");
        FastScatterPlot fastScatterPlot = new FastScatterPlot(fArray, numberAxis, numberAxis2);
        FastScatterPlot fastScatterPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(fastScatterPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            fastScatterPlot2 = (FastScatterPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        FastScatterPlotTests.assertEquals((Object)fastScatterPlot, fastScatterPlot2);
    }

    private float[][] createData() {
        float[][] fArray = new float[2][1000];
        for (int i = 0; i < fArray[0].length; ++i) {
            float f;
            fArray[0][i] = f = (float)i + 100.0f;
            fArray[1][i] = 100.0f + (float)Math.random() * 1000.0f;
        }
        return fArray;
    }
}

