/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.plot.CompassPlot;
import org.jfree.data.general.DefaultValueDataset;

public class CompassPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CompassPlotTests.class);
    }

    public CompassPlotTests(String string) {
        super(string);
    }

    public void testEquals() {
        CompassPlot compassPlot = new CompassPlot();
        CompassPlot compassPlot2 = new CompassPlot();
        CompassPlotTests.assertTrue((boolean)compassPlot.equals(compassPlot2));
        compassPlot.setLabelType(1);
        CompassPlotTests.assertFalse((boolean)compassPlot.equals(compassPlot2));
        compassPlot2.setLabelType(1);
        CompassPlotTests.assertTrue((boolean)compassPlot.equals(compassPlot2));
    }

    public void testSerialization() {
        CompassPlot compassPlot = new CompassPlot(null);
        CompassPlot compassPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(compassPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            compassPlot2 = (CompassPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        CompassPlotTests.assertEquals((Object)compassPlot, compassPlot2);
    }

    public void testCloning() {
        CompassPlot compassPlot = new CompassPlot(new DefaultValueDataset(15.0));
        CompassPlot compassPlot2 = null;
        try {
            compassPlot2 = (CompassPlot)compassPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        CompassPlotTests.assertTrue((compassPlot != compassPlot2 ? 1 : 0) != 0);
        CompassPlotTests.assertTrue((compassPlot.getClass() == compassPlot2.getClass() ? 1 : 0) != 0);
        CompassPlotTests.assertTrue((boolean)compassPlot.equals(compassPlot2));
    }
}

