/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.annotations.CategoryTextAnnotation;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.AxisSpace;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.chart.plot.IntervalMarker;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.junit.MyPlotChangeListener;
import org.jfree.chart.renderer.category.AreaRenderer;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.Range;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.AbstractDataset;
import org.jfree.ui.Layer;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.SortOrder;

public class CategoryPlotTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(CategoryPlotTests.class);
    }

    public CategoryPlotTests(String string) {
        super(string);
    }

    public void testAxisRange() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
        defaultCategoryDataset2.addValue(50.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        defaultCategoryDataset2.addValue(80.0, (Comparable)((Object)"R1"), (Comparable)((Object)"C1"));
        CategoryPlot categoryPlot = new CategoryPlot(defaultCategoryDataset, new CategoryAxis(null), new NumberAxis(null), new LineAndShapeRenderer());
        categoryPlot.setDataset(1, defaultCategoryDataset2);
        categoryPlot.setRenderer(1, new LineAndShapeRenderer());
        Range range = categoryPlot.getRangeAxis().getRange();
        CategoryPlotTests.assertEquals((double)84.0, (double)range.getUpperBound(), (double)1.0E-5);
    }

    public void testEquals() {
        CategoryPlot categoryPlot = new CategoryPlot();
        CategoryPlot categoryPlot2 = new CategoryPlot();
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)categoryPlot2.equals(categoryPlot));
        categoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setAxisOffset(new RectangleInsets(0.05, 0.05, 0.05, 0.05));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainAxis(new CategoryAxis("Category Axis"));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainAxis(new CategoryAxis("Category Axis"));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainAxis(11, new CategoryAxis("Secondary Axis"));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDrawSharedDomainAxis(!categoryPlot.getDrawSharedDomainAxis());
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDrawSharedDomainAxis(!categoryPlot2.getDrawSharedDomainAxis());
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeAxis(new NumberAxis("Range Axis"));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeAxis(new NumberAxis("Range Axis"));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeAxis(11, new NumberAxis("Secondary Range Axis"));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeAxisLocation(AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeAxisLocation(11, AxisLocation.TOP_OR_RIGHT);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.mapDatasetToDomainAxis(11, 11);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.mapDatasetToDomainAxis(11, 11);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.mapDatasetToRangeAxis(11, 11);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.mapDatasetToRangeAxis(11, 11);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRenderer(new AreaRenderer());
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRenderer(new AreaRenderer());
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRenderer(11, new AreaRenderer());
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRenderer(11, new AreaRenderer());
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDatasetRenderingOrder(DatasetRenderingOrder.FORWARD);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setColumnRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setColumnRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRowRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRowRenderingOrder(SortOrder.DESCENDING);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainGridlinesVisible(true);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainGridlinesVisible(true);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainGridlinePosition(CategoryAnchor.END);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainGridlinePosition(CategoryAnchor.END);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        BasicStroke basicStroke = new BasicStroke(2.0f);
        categoryPlot.setDomainGridlineStroke(basicStroke);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainGridlineStroke(basicStroke);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setDomainGridlinePaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setDomainGridlinePaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeGridlinesVisible(false);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeGridlinesVisible(false);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeGridlineStroke(basicStroke);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeGridlineStroke(basicStroke);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeGridlinePaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeGridlinePaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setAnchorValue(100.0);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setAnchorValue(100.0);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeCrosshairVisible(true);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeCrosshairVisible(true);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeCrosshairValue(100.0);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeCrosshairValue(100.0);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeCrosshairStroke(basicStroke);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeCrosshairStroke(basicStroke);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeCrosshairPaint(Color.blue);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeCrosshairPaint(Color.blue);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setRangeCrosshairLockedOnData(false);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setRangeCrosshairLockedOnData(false);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.addRangeMarker(new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.addRangeMarker(new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.addRangeMarker(1, new ValueMarker(4.0), Layer.FOREGROUND);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.addRangeMarker(1, new ValueMarker(5.0), Layer.BACKGROUND);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.addAnnotation(new CategoryTextAnnotation("Text", (Comparable)((Object)"Category"), 43.0));
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setWeight(3);
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setWeight(3);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setFixedDomainAxisSpace(new AxisSpace());
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setFixedDomainAxisSpace(new AxisSpace());
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot.setFixedRangeAxisSpace(new AxisSpace());
        CategoryPlotTests.assertFalse((boolean)categoryPlot.equals(categoryPlot2));
        categoryPlot2.setFixedRangeAxisSpace(new AxisSpace());
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
    }

    public void testCloning() {
        CategoryPlot categoryPlot = new CategoryPlot();
        CategoryPlot categoryPlot2 = null;
        try {
            categoryPlot2 = (CategoryPlot)categoryPlot.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
            System.err.println("Failed to clone.");
        }
        CategoryPlotTests.assertTrue((categoryPlot != categoryPlot2 ? 1 : 0) != 0);
        CategoryPlotTests.assertTrue((categoryPlot.getClass() == categoryPlot2.getClass() ? 1 : 0) != 0);
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
    }

    public void testSerialization() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        CategoryAxis categoryAxis = new CategoryAxis("Domain");
        NumberAxis numberAxis = new NumberAxis("Range");
        BarRenderer barRenderer = new BarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(defaultCategoryDataset, categoryAxis, numberAxis, barRenderer);
        categoryPlot.setOrientation(PlotOrientation.HORIZONTAL);
        CategoryPlot categoryPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryPlot2 = (CategoryPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)categoryPlot.equals(categoryPlot2));
    }

    public void testSerialization2() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        CategoryAxis categoryAxis = new CategoryAxis("Domain");
        NumberAxis numberAxis = new NumberAxis("Range");
        BarRenderer barRenderer = new BarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(defaultCategoryDataset, categoryAxis, numberAxis, barRenderer);
        categoryPlot.setOrientation(PlotOrientation.VERTICAL);
        CategoryPlot categoryPlot2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(categoryPlot);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            categoryPlot2 = (CategoryPlot)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            CategoryPlotTests.fail((String)exception.toString());
        }
        CategoryPlotTests.assertEquals((Object)categoryPlot, categoryPlot2);
    }

    public void testSerialization3() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart("Test Chart", "Category Axis", "Value Axis", defaultCategoryDataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            CategoryPlotTests.fail((String)exception.toString());
        }
        boolean bl = true;
        try {
            jFreeChart2.createBufferedImage(300, 200);
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)bl);
    }

    public void testSerialization4() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        JFreeChart jFreeChart = ChartFactory.createBarChart("Test Chart", "Category Axis", "Value Axis", defaultCategoryDataset, PlotOrientation.VERTICAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.addRangeMarker(new ValueMarker(1.1), Layer.FOREGROUND);
        categoryPlot.addRangeMarker(new IntervalMarker(2.2, 3.3), Layer.BACKGROUND);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            CategoryPlotTests.fail((String)exception.toString());
        }
        CategoryPlotTests.assertEquals((Object)jFreeChart, jFreeChart2);
        boolean bl = true;
        try {
            jFreeChart2.createBufferedImage(300, 200);
        }
        catch (Exception exception) {
            bl = false;
            exception.printStackTrace();
        }
        CategoryPlotTests.assertTrue((boolean)bl);
    }

    public void testSerialization5() {
        Object object;
        Object object2;
        Object object3;
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        CategoryAxis categoryAxis = new CategoryAxis("Domain 1");
        NumberAxis numberAxis = new NumberAxis("Range 1");
        BarRenderer barRenderer = new BarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(defaultCategoryDataset, categoryAxis, numberAxis, barRenderer);
        CategoryAxis categoryAxis2 = new CategoryAxis("Domain 2");
        NumberAxis numberAxis2 = new NumberAxis("Range 2");
        BarRenderer barRenderer2 = new BarRenderer();
        DefaultCategoryDataset defaultCategoryDataset2 = new DefaultCategoryDataset();
        categoryPlot.setDataset(1, defaultCategoryDataset2);
        categoryPlot.setDomainAxis(1, categoryAxis2);
        categoryPlot.setRangeAxis(1, numberAxis2);
        categoryPlot.setRenderer(1, barRenderer2);
        CategoryPlot categoryPlot2 = null;
        try {
            object3 = new ByteArrayOutputStream();
            object2 = new ObjectOutputStream((OutputStream)object3);
            object2.writeObject(categoryPlot);
            object2.close();
            object = new ObjectInputStream(new ByteArrayInputStream(((ByteArrayOutputStream)object3).toByteArray()));
            categoryPlot2 = (CategoryPlot)object.readObject();
            object.close();
        }
        catch (Exception exception) {
            CategoryPlotTests.fail((String)exception.toString());
        }
        CategoryPlotTests.assertEquals((Object)categoryPlot, categoryPlot2);
        object3 = categoryPlot2.getDomainAxis(0);
        object2 = (NumberAxis)categoryPlot2.getRangeAxis(0);
        object = (DefaultCategoryDataset)categoryPlot2.getDataset(0);
        BarRenderer barRenderer3 = (BarRenderer)categoryPlot2.getRenderer(0);
        CategoryAxis categoryAxis3 = categoryPlot2.getDomainAxis(1);
        NumberAxis numberAxis3 = (NumberAxis)categoryPlot2.getRangeAxis(1);
        DefaultCategoryDataset defaultCategoryDataset3 = (DefaultCategoryDataset)categoryPlot2.getDataset(1);
        BarRenderer barRenderer4 = (BarRenderer)categoryPlot2.getRenderer(1);
        CategoryPlotTests.assertTrue((boolean)((AbstractDataset)object).hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)((Axis)object3).hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)((Axis)object2).hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)barRenderer3.hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)defaultCategoryDataset3.hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)categoryAxis3.hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)numberAxis3.hasListener(categoryPlot2));
        CategoryPlotTests.assertTrue((boolean)barRenderer4.hasListener(categoryPlot2));
    }

    public void testSetRenderer() {
        CategoryPlot categoryPlot = new CategoryPlot();
        LineAndShapeRenderer lineAndShapeRenderer = new LineAndShapeRenderer();
        categoryPlot.setRenderer(lineAndShapeRenderer);
        MyPlotChangeListener myPlotChangeListener = new MyPlotChangeListener();
        categoryPlot.addChangeListener(myPlotChangeListener);
        lineAndShapeRenderer.setSeriesPaint(0, Color.black);
        CategoryPlotTests.assertTrue((myPlotChangeListener.getEvent() != null ? 1 : 0) != 0);
    }

    public void test1169972() {
        CategoryPlot categoryPlot = new CategoryPlot(null, null, null, null);
        categoryPlot.setDomainAxis(new CategoryAxis("C"));
        categoryPlot.setRangeAxis(new NumberAxis("Y"));
        categoryPlot.setRenderer(new BarRenderer());
        categoryPlot.setDataset(new DefaultCategoryDataset());
        CategoryPlotTests.assertTrue((categoryPlot != null ? 1 : 0) != 0);
    }
}

