/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.io.Serializable;
import java.util.ResourceBundle;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.event.RendererChangeEvent;
import org.jfree.chart.event.RendererChangeListener;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.renderer.WaferMapRenderer;
import org.jfree.data.general.WaferMapDataset;
import org.jfree.ui.RectangleInsets;

public class WaferMapPlot
extends Plot
implements RendererChangeListener,
Cloneable,
Serializable {
    private static final long serialVersionUID = 4668320403707308155L;
    public static final Stroke DEFAULT_GRIDLINE_STROKE = new BasicStroke(0.5f, 0, 2, 0.0f, new float[]{2.0f, 2.0f}, 0.0f);
    public static final Paint DEFAULT_GRIDLINE_PAINT = Color.lightGray;
    public static final boolean DEFAULT_CROSSHAIR_VISIBLE = false;
    public static final Stroke DEFAULT_CROSSHAIR_STROKE = DEFAULT_GRIDLINE_STROKE;
    public static final Paint DEFAULT_CROSSHAIR_PAINT = Color.blue;
    protected static ResourceBundle localizationResources = ResourceBundle.getBundle("org.jfree.chart.plot.LocalizationBundle");
    private PlotOrientation orientation = PlotOrientation.VERTICAL;
    private WaferMapDataset dataset;
    private WaferMapRenderer renderer;

    public WaferMapPlot(WaferMapDataset waferMapDataset) {
        this(waferMapDataset, null);
    }

    public WaferMapPlot(WaferMapDataset waferMapDataset, WaferMapRenderer waferMapRenderer) {
        this.dataset = waferMapDataset;
        if (waferMapDataset != null) {
            waferMapDataset.addChangeListener(this);
        }
        this.renderer = waferMapRenderer;
        if (waferMapRenderer != null) {
            waferMapRenderer.setPlot(this);
            waferMapRenderer.addChangeListener(this);
        }
    }

    public String getPlotType() {
        return "WMAP_Plot";
    }

    public void setRenderer(WaferMapRenderer waferMapRenderer) {
        if (this.renderer != null) {
            this.renderer.removeChangeListener(this);
        }
        this.renderer = waferMapRenderer;
        if (waferMapRenderer != null) {
            waferMapRenderer.setPlot(this);
        }
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        boolean bl;
        boolean bl2 = rectangle2D.getWidth() <= 10.0;
        boolean bl3 = bl = rectangle2D.getHeight() <= 10.0;
        if (bl2 || bl) {
            return;
        }
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
        }
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawChipGrid(graphics2D, rectangle2D);
        this.drawWaferEdge(graphics2D, rectangle2D);
    }

    private void drawChipGrid(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Shape shape = graphics2D.getClip();
        graphics2D.setClip(this.getWaferEdge(rectangle2D));
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        int n = 35;
        int n2 = 20;
        double d = 1.0;
        if (this.dataset != null) {
            n = this.dataset.getMaxChipX() + 2;
            n2 = this.dataset.getMaxChipY() + 2;
            d = this.dataset.getChipSpace();
        }
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = 1.0;
        double d5 = 1.0;
        if (rectangle2D.getWidth() != rectangle2D.getHeight()) {
            double d6 = 0.0;
            double d7 = 0.0;
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                d6 = rectangle2D.getWidth();
                d7 = rectangle2D.getHeight();
            } else {
                d6 = rectangle2D.getHeight();
                d7 = rectangle2D.getWidth();
            }
            if (rectangle2D.getWidth() == d7) {
                d3 += (d6 - d7) / 2.0;
                d4 = (rectangle2D.getWidth() - (d * (double)n - 1.0)) / (double)n;
                d5 = (rectangle2D.getWidth() - (d * (double)n2 - 1.0)) / (double)n2;
            } else {
                d2 += (d6 - d7) / 2.0;
                d4 = (rectangle2D.getHeight() - (d * (double)n - 1.0)) / (double)n;
                d5 = (rectangle2D.getHeight() - (d * (double)n2 - 1.0)) / (double)n2;
            }
        }
        for (int i = 1; i <= n; ++i) {
            double d8 = d2 - d4 + d4 * (double)i + d * (double)(i - 1);
            for (int j = 1; j <= n2; ++j) {
                double d9 = d3 - d5 + d5 * (double)j + d * (double)(j - 1);
                double_.setFrame(d8, d9, d4, d5);
                graphics2D.setColor(Color.white);
                if (this.dataset.getChipValue(i - 1, n2 - j - 1) != null) {
                    graphics2D.setPaint(this.renderer.getChipColor(this.dataset.getChipValue(i - 1, n2 - j - 1)));
                }
                graphics2D.fill(double_);
                graphics2D.setColor(Color.lightGray);
                graphics2D.draw(double_);
            }
        }
        graphics2D.setClip(shape);
    }

    private Ellipse2D getWaferEdge(Rectangle2D rectangle2D) {
        Ellipse2D.Double double_ = new Ellipse2D.Double();
        double d = rectangle2D.getWidth();
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        if (rectangle2D.getWidth() != rectangle2D.getHeight()) {
            double d4 = 0.0;
            double d5 = 0.0;
            if (rectangle2D.getWidth() > rectangle2D.getHeight()) {
                d4 = rectangle2D.getWidth();
                d5 = rectangle2D.getHeight();
            } else {
                d4 = rectangle2D.getHeight();
                d5 = rectangle2D.getWidth();
            }
            d = d5;
            if (rectangle2D.getWidth() == d5) {
                d3 = rectangle2D.getY() + (d4 - d5) / 2.0;
            } else {
                d2 = rectangle2D.getX() + (d4 - d5) / 2.0;
            }
        }
        ((RectangularShape)double_).setFrame(d2, d3, d, d);
        return double_;
    }

    private void drawWaferEdge(Graphics2D graphics2D, Rectangle2D rectangle2D) {
        Ellipse2D ellipse2D = this.getWaferEdge(rectangle2D);
        graphics2D.setColor(Color.black);
        graphics2D.draw(ellipse2D);
        Arc2D.Double double_ = null;
        Rectangle2D rectangle2D2 = ellipse2D.getFrame();
        double d = rectangle2D2.getWidth() * 0.04;
        if (this.orientation == PlotOrientation.HORIZONTAL) {
            Rectangle2D.Double double_2 = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() - d / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() / 2.0 - d / 2.0, d, d);
            double_ = new Arc2D.Double(double_2, 90.0, 180.0, 0);
        } else {
            Rectangle2D.Double double_3 = new Rectangle2D.Double(rectangle2D2.getX() + rectangle2D2.getWidth() / 2.0 - d / 2.0, rectangle2D2.getY() + rectangle2D2.getHeight() - d / 2.0, d, d);
            double_ = new Arc2D.Double(double_3, 0.0, 180.0, 0);
        }
        graphics2D.setColor(Color.white);
        graphics2D.fill(double_);
        graphics2D.setColor(Color.black);
        graphics2D.draw(double_);
    }

    public WaferMapDataset getDataset() {
        return this.dataset;
    }

    public LegendItemCollection getLegendItems() {
        return this.renderer.getLegendCollection();
    }

    public void rendererChanged(RendererChangeEvent rendererChangeEvent) {
        this.notifyListeners(new PlotChangeEvent(this));
    }
}

