/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.DrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.PaintList;
import org.jfree.util.Rotation;
import org.jfree.util.StrokeList;
import org.jfree.util.TableOrder;

public class SpiderWebPlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -5376340422031599463L;
    public static final double DEFAULT_HEAD = 0.01;
    public static final double DEFAULT_AXIS_LABEL_GAP = 0.1;
    public static final double DEFAULT_INTERIOR_GAP = 0.25;
    public static final double MAX_INTERIOR_GAP = 0.4;
    public static final double DEFAULT_START_ANGLE = 90.0;
    public static final Font DEFAULT_LABEL_FONT = new Font("SansSerif", 0, 10);
    public static final Paint DEFAULT_LABEL_PAINT = Color.black;
    public static final Paint DEFAULT_LABEL_BACKGROUND_PAINT = new Color(255, 255, 192);
    public static final Paint DEFAULT_LABEL_OUTLINE_PAINT = Color.black;
    public static final Stroke DEFAULT_LABEL_OUTLINE_STROKE = new BasicStroke(0.5f);
    public static final Paint DEFAULT_LABEL_SHADOW_PAINT = Color.lightGray;
    public static final double DEFAULT_MAX_VALUE = -1.0;
    protected double headPercent;
    private double interiorGap;
    private double axisLabelGap;
    private CategoryDataset dataset;
    private double maxValue;
    private TableOrder dataExtractOrder;
    private double startAngle;
    private Rotation direction;
    private transient Shape legendItemShape;
    private transient Paint seriesPaint;
    private PaintList seriesPaintList;
    private transient Paint baseSeriesPaint;
    private transient Paint seriesOutlinePaint;
    private PaintList seriesOutlinePaintList;
    private transient Paint baseSeriesOutlinePaint;
    private transient Stroke seriesOutlineStroke;
    private StrokeList seriesOutlineStrokeList;
    private transient Stroke baseSeriesOutlineStroke;
    private Font labelFont;
    private transient Paint labelPaint;
    private CategoryItemLabelGenerator labelGenerator;
    private boolean webFilled = true;

    public SpiderWebPlot(CategoryDataset categoryDataset) {
        this.dataset = categoryDataset;
        if (categoryDataset != null) {
            categoryDataset.addChangeListener(this);
        }
        this.dataExtractOrder = TableOrder.BY_ROW;
        this.headPercent = 0.01;
        this.axisLabelGap = 0.1;
        this.interiorGap = 0.25;
        this.startAngle = 90.0;
        this.direction = Rotation.CLOCKWISE;
        this.maxValue = -1.0;
        this.seriesPaint = null;
        this.seriesPaintList = new PaintList();
        this.baseSeriesPaint = null;
        this.seriesOutlinePaint = null;
        this.seriesOutlinePaintList = new PaintList();
        this.baseSeriesOutlinePaint = DEFAULT_OUTLINE_PAINT;
        this.seriesOutlineStroke = null;
        this.seriesOutlineStrokeList = new StrokeList();
        this.baseSeriesOutlineStroke = DEFAULT_OUTLINE_STROKE;
        this.labelFont = DEFAULT_LABEL_FONT;
        this.labelPaint = DEFAULT_LABEL_PAINT;
        this.labelGenerator = new StandardCategoryItemLabelGenerator();
        this.legendItemShape = DEFAULT_LEGEND_ITEM_CIRCLE;
    }

    public SpiderWebPlot(CategoryDataset categoryDataset, TableOrder tableOrder) {
        this(categoryDataset);
        this.dataExtractOrder = tableOrder;
    }

    public String getPlotType() {
        return "Radar Plot";
    }

    public boolean isWebFilled() {
        return this.webFilled;
    }

    public void setWebFilled(boolean bl) {
        this.webFilled = bl;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder tableOrder) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument");
        }
        this.dataExtractOrder = tableOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getStartAngle() {
        return this.startAngle;
    }

    public void setStartAngle(double d) {
        this.startAngle = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(double d) {
        this.maxValue = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Rotation getDirection() {
        return this.direction;
    }

    public void setDirection(Rotation rotation) {
        if (rotation == null) {
            throw new IllegalArgumentException("Null 'direction' argument.");
        }
        this.direction = rotation;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getInteriorGap() {
        return this.interiorGap;
    }

    public void setInteriorGap(double d) {
        if (d < 0.0 || d > 0.4) {
            throw new IllegalArgumentException("Percentage outside valid range.");
        }
        if (this.interiorGap != d) {
            this.interiorGap = d;
            this.notifyListeners(new PlotChangeEvent(this));
        }
    }

    public Paint getSeriesPaint() {
        return this.seriesPaint;
    }

    public void setSeriesPaint(Paint paint) {
        this.seriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesPaint(int n) {
        if (this.seriesPaint != null) {
            return this.seriesPaint;
        }
        Paint paint = this.seriesPaintList.getPaint(n);
        if (paint == null) {
            DrawingSupplier drawingSupplier = this.getDrawingSupplier();
            if (drawingSupplier != null) {
                Paint paint2 = drawingSupplier.getNextPaint();
                this.seriesPaintList.setPaint(n, paint2);
                paint = paint2;
            } else {
                paint = this.baseSeriesPaint;
            }
        }
        return paint;
    }

    public void setSeriesPaint(int n, Paint paint) {
        this.seriesPaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSeriesPaint() {
        return this.baseSeriesPaint;
    }

    public void setBaseSeriesPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint() {
        return this.seriesOutlinePaint;
    }

    public void setSeriesOutlinePaint(Paint paint) {
        this.seriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getSeriesOutlinePaint(int n) {
        if (this.seriesOutlinePaint != null) {
            return this.seriesOutlinePaint;
        }
        Paint paint = this.seriesOutlinePaintList.getPaint(n);
        if (paint == null) {
            paint = this.baseSeriesOutlinePaint;
        }
        return paint;
    }

    public void setSeriesOutlinePaint(int n, Paint paint) {
        this.seriesOutlinePaintList.setPaint(n, paint);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getBaseSeriesOutlinePaint() {
        return this.baseSeriesOutlinePaint;
    }

    public void setBaseSeriesOutlinePaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.baseSeriesOutlinePaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke() {
        return this.seriesOutlineStroke;
    }

    public void setSeriesOutlineStroke(Stroke stroke) {
        this.seriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getSeriesOutlineStroke(int n) {
        if (this.seriesOutlineStroke != null) {
            return this.seriesOutlineStroke;
        }
        Stroke stroke = this.seriesOutlineStrokeList.getStroke(n);
        if (stroke == null) {
            stroke = this.baseSeriesOutlineStroke;
        }
        return stroke;
    }

    public void setSeriesOutlineStroke(int n, Stroke stroke) {
        this.seriesOutlineStrokeList.setStroke(n, stroke);
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Stroke getBaseSeriesOutlineStroke() {
        return this.baseSeriesOutlineStroke;
    }

    public void setBaseSeriesOutlineStroke(Stroke stroke) {
        if (stroke == null) {
            throw new IllegalArgumentException("Null 'stroke' argument.");
        }
        this.baseSeriesOutlineStroke = stroke;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Shape getLegendItemShape() {
        return this.legendItemShape;
    }

    public void setLegendItemShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException("Null 'shape' argument.");
        }
        this.legendItemShape = shape;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Font getLabelFont() {
        return this.labelFont;
    }

    public void setLabelFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("Null 'font' argument.");
        }
        this.labelFont = font;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public Paint getLabelPaint() {
        return this.labelPaint;
    }

    public void setLabelPaint(Paint paint) {
        if (paint == null) {
            throw new IllegalArgumentException("Null 'paint' argument.");
        }
        this.labelPaint = paint;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public CategoryItemLabelGenerator getLabelGenerator() {
        return this.labelGenerator;
    }

    public void setLabelGenerator(CategoryItemLabelGenerator categoryItemLabelGenerator) {
        if (categoryItemLabelGenerator == null) {
            throw new IllegalArgumentException("Null 'generator' argument.");
        }
        this.labelGenerator = categoryItemLabelGenerator;
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        List list = null;
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            list = this.dataset.getRowKeys();
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            list = this.dataset.getColumnKeys();
        }
        if (list != null) {
            int n = 0;
            Iterator iterator = list.iterator();
            Shape shape = this.getLegendItemShape();
            while (iterator.hasNext()) {
                String string;
                String string2 = string = iterator.next().toString();
                Paint paint = this.getSeriesPaint(n);
                Paint paint2 = this.getSeriesOutlinePaint(n);
                Stroke stroke = this.getSeriesOutlineStroke(n);
                LegendItem legendItem = new LegendItem(string, string2, null, null, shape, paint, stroke, paint2);
                legendItemCollection.add(legendItem);
                ++n;
            }
        }
        return legendItemCollection;
    }

    protected Point2D getWebPoint(Rectangle2D rectangle2D, double d, double d2) {
        double d3 = Math.toRadians(d);
        double d4 = Math.cos(d3) * d2 * rectangle2D.getWidth() / 2.0;
        double d5 = -Math.sin(d3) * d2 * rectangle2D.getHeight() / 2.0;
        return new Point2D.Double(rectangle2D.getX() + d4 + rectangle2D.getWidth() / 2.0, rectangle2D.getY() + d5 + rectangle2D.getHeight() / 2.0);
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        if (plotRenderingInfo != null) {
            plotRenderingInfo.setPlotArea(rectangle2D);
            plotRenderingInfo.setDataArea(rectangle2D);
        }
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        Shape shape = graphics2D.getClip();
        graphics2D.clip(rectangle2D);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        if (!DatasetUtilities.isEmptyOrNull(this.dataset)) {
            int n = 0;
            int n2 = 0;
            if (this.dataExtractOrder == TableOrder.BY_ROW) {
                n = this.dataset.getRowCount();
                n2 = this.dataset.getColumnCount();
            } else {
                n = this.dataset.getColumnCount();
                n2 = this.dataset.getRowCount();
            }
            if (this.maxValue == -1.0) {
                this.calculateMaxValue(n, n2);
            }
            double d = rectangle2D.getWidth() * this.getInteriorGap();
            double d2 = rectangle2D.getHeight() * this.getInteriorGap();
            double d3 = rectangle2D.getX() + d / 2.0;
            double d4 = rectangle2D.getY() + d2 / 2.0;
            double d5 = rectangle2D.getWidth() - d;
            double d6 = rectangle2D.getHeight() - d2;
            double d7 = rectangle2D.getWidth() * this.headPercent;
            double d8 = rectangle2D.getHeight() * this.headPercent;
            double d9 = Math.min(d5, d6) / 2.0;
            d3 = (d3 + d3 + d5) / 2.0 - d9;
            d4 = (d4 + d4 + d6) / 2.0 - d9;
            d5 = 2.0 * d9;
            d6 = 2.0 * d9;
            Point2D.Double double_ = new Point2D.Double(d3 + d5 / 2.0, d4 + d6 / 2.0);
            Rectangle2D.Double double_2 = new Rectangle2D.Double(d3, d4, d5, d6);
            for (int i = 0; i < n; ++i) {
                this.drawRadarPoly(graphics2D, double_2, double_, plotRenderingInfo, i, n2, d8, d7);
            }
        } else {
            this.drawNoDataMessage(graphics2D, rectangle2D);
        }
        graphics2D.clip(shape);
        graphics2D.setComposite(composite);
        this.drawOutline(graphics2D, rectangle2D);
    }

    private void calculateMaxValue(int n, int n2) {
        double d = 0.0;
        Number number = null;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                number = this.getPlotValue(i, j);
                if (number == null || !((d = number.doubleValue()) > this.maxValue)) continue;
                this.maxValue = d;
            }
        }
    }

    protected void drawRadarPoly(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotRenderingInfo plotRenderingInfo, int n, int n2, double d, double d2) {
        Polygon polygon = new Polygon();
        for (int i = 0; i < n2; ++i) {
            double d3;
            Number number = this.getPlotValue(n, i);
            if (number == null || !((d3 = number.doubleValue()) > 0.0)) continue;
            double d4 = this.getStartAngle() + this.getDirection().getFactor() * (double)i * 360.0 / (double)n2;
            Point2D point2D2 = this.getWebPoint(rectangle2D, d4, d3 / this.maxValue);
            polygon.addPoint((int)point2D2.getX(), (int)point2D2.getY());
            Paint paint = this.getSeriesPaint(n);
            Paint paint2 = this.getSeriesOutlinePaint(n);
            Stroke stroke = this.getSeriesOutlineStroke(n);
            Ellipse2D.Double double_ = new Ellipse2D.Double(point2D2.getX() - d2 / 2.0, point2D2.getY() - d / 2.0, d2, d);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            graphics2D.setStroke(stroke);
            graphics2D.setPaint(paint2);
            graphics2D.draw(double_);
            if (n != 0) continue;
            Point2D point2D3 = this.getWebPoint(rectangle2D, d4, 1.0);
            Line2D.Double double_2 = new Line2D.Double(point2D, point2D3);
            graphics2D.draw(double_2);
            this.drawLabel(graphics2D, rectangle2D, d3, i, d4, 360.0 / (double)n2);
        }
        Paint paint = this.getSeriesPaint(n);
        graphics2D.setPaint(paint);
        graphics2D.draw(polygon);
        if (this.webFilled) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.1f));
            graphics2D.fill(polygon);
            graphics2D.setComposite(AlphaComposite.getInstance(3, this.getForegroundAlpha()));
        }
    }

    Number getPlotValue(int n, int n2) {
        Number number = null;
        if (this.dataExtractOrder == TableOrder.BY_ROW) {
            number = this.dataset.getValue(n, n2);
        } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
            number = this.dataset.getValue(n2, n);
        }
        return number;
    }

    protected void drawLabel(Graphics2D graphics2D, Rectangle2D rectangle2D, double d, int n, double d2, double d3) {
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        String string = null;
        string = this.dataExtractOrder == TableOrder.BY_ROW ? this.labelGenerator.generateColumnLabel(this.dataset, n) : this.labelGenerator.generateRowLabel(this.dataset, n);
        Rectangle2D rectangle2D2 = this.getLabelFont().getStringBounds(string, fontRenderContext);
        LineMetrics lineMetrics = this.getLabelFont().getLineMetrics(string, fontRenderContext);
        double d4 = lineMetrics.getAscent();
        Point2D point2D = this.calculateLabelLocation(rectangle2D2, d4, rectangle2D, d2);
        Composite composite = graphics2D.getComposite();
        graphics2D.setComposite(AlphaComposite.getInstance(3, 1.0f));
        graphics2D.setPaint(this.getLabelPaint());
        graphics2D.setFont(this.getLabelFont());
        graphics2D.drawString(string, (float)point2D.getX(), (float)point2D.getY());
        graphics2D.setComposite(composite);
    }

    protected Point2D calculateLabelLocation(Rectangle2D rectangle2D, double d, Rectangle2D rectangle2D2, double d2) {
        Arc2D.Double double_ = new Arc2D.Double(rectangle2D2, d2, 0.0, 0);
        Point2D point2D = double_.getEndPoint();
        double d3 = -(point2D.getX() - rectangle2D2.getCenterX()) * this.axisLabelGap;
        double d4 = -(point2D.getY() - rectangle2D2.getCenterY()) * this.axisLabelGap;
        double d5 = point2D.getX() - d3;
        double d6 = point2D.getY() - d4;
        if (d5 < rectangle2D2.getCenterX()) {
            d5 -= rectangle2D.getWidth();
        }
        if (d5 == rectangle2D2.getCenterX()) {
            d5 -= rectangle2D.getWidth() / 2.0;
        }
        if (d6 > rectangle2D2.getCenterY()) {
            d6 += d;
        }
        return new Point2D.Double(d5, d6);
    }
}

