/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import org.jfree.text.TextBox;

public class PieLabelRecord
implements Comparable {
    private Comparable key;
    private double angle;
    private double baseY;
    private double allocatedY;
    private TextBox label;
    private double labelHeight;
    private double gap;
    private double linkPercent;

    public PieLabelRecord(Comparable comparable, double d, double d2, TextBox textBox, double d3, double d4, double d5) {
        this.key = comparable;
        this.angle = d;
        this.baseY = d2;
        this.allocatedY = d2;
        this.label = textBox;
        this.labelHeight = d3;
        this.gap = d4;
        this.linkPercent = d5;
    }

    public double getBaseY() {
        return this.baseY;
    }

    public void setBaseY(double d) {
        this.baseY = d;
    }

    public double getLowerY() {
        return this.allocatedY - this.labelHeight / 2.0;
    }

    public double getUpperY() {
        return this.allocatedY + this.labelHeight / 2.0;
    }

    public double getAngle() {
        return this.angle;
    }

    public Comparable getKey() {
        return this.key;
    }

    public TextBox getLabel() {
        return this.label;
    }

    public double getLabelHeight() {
        return this.labelHeight;
    }

    public double getAllocatedY() {
        return this.allocatedY;
    }

    public void setAllocatedY(double d) {
        this.allocatedY = d;
    }

    public double getGap() {
        return this.gap;
    }

    public double getLinkPercent() {
        return this.linkPercent;
    }

    public int compareTo(Object object) {
        int n = 0;
        if (object instanceof PieLabelRecord) {
            PieLabelRecord pieLabelRecord = (PieLabelRecord)object;
            if (this.baseY < pieLabelRecord.baseY) {
                n = -1;
            } else if (this.baseY > pieLabelRecord.baseY) {
                n = 1;
            }
        }
        return n;
    }

    public String toString() {
        return this.baseY + ", " + this.key.toString();
    }
}

