/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.plot;

import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.event.PlotChangeEvent;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotRenderingInfo;
import org.jfree.chart.plot.PlotState;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.CategoryToPieDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.general.PieDataset;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RectangleInsets;
import org.jfree.util.TableOrder;

public class MultiplePiePlot
extends Plot
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -355377800470807389L;
    private JFreeChart pieChart;
    private CategoryDataset dataset;
    private TableOrder dataExtractOrder;
    private double limit = 0.0;

    public MultiplePiePlot() {
        this(null);
    }

    public MultiplePiePlot(CategoryDataset categoryDataset) {
        this.dataset = categoryDataset;
        PiePlot piePlot = new PiePlot(null);
        this.pieChart = new JFreeChart(piePlot);
        this.pieChart.removeLegend();
        this.dataExtractOrder = TableOrder.BY_COLUMN;
        this.pieChart.setBackgroundPaint(null);
        TextTitle textTitle = new TextTitle("Series Title", new Font("SansSerif", 1, 12));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        this.pieChart.setTitle(textTitle);
    }

    public JFreeChart getPieChart() {
        return this.pieChart;
    }

    public void setPieChart(JFreeChart jFreeChart) {
        this.pieChart = jFreeChart;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public TableOrder getDataExtractOrder() {
        return this.dataExtractOrder;
    }

    public void setDataExtractOrder(TableOrder tableOrder) {
        if (tableOrder == null) {
            throw new IllegalArgumentException("Null 'order' argument");
        }
        this.dataExtractOrder = tableOrder;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public double getLimit() {
        return this.limit;
    }

    public void setLimit(double d) {
        this.limit = d;
        this.notifyListeners(new PlotChangeEvent(this));
    }

    public String getPlotType() {
        return "Multiple Pie Plot";
    }

    public void draw(Graphics2D graphics2D, Rectangle2D rectangle2D, Point2D point2D, PlotState plotState, PlotRenderingInfo plotRenderingInfo) {
        int n;
        int n2;
        RectangleInsets rectangleInsets = this.getInsets();
        rectangleInsets.trim(rectangle2D);
        this.drawBackground(graphics2D, rectangle2D);
        this.drawOutline(graphics2D, rectangle2D);
        if (DatasetUtilities.isEmptyOrNull(this.dataset)) {
            this.drawNoDataMessage(graphics2D, rectangle2D);
            return;
        }
        int n3 = 0;
        n3 = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowCount() : this.dataset.getColumnCount();
        int n4 = (int)Math.ceil(Math.sqrt(n3));
        if (n4 > (n2 = (int)Math.ceil((double)n3 / (double)n4)) && rectangle2D.getWidth() < rectangle2D.getHeight()) {
            n = n4;
            n4 = n2;
            n2 = n;
        }
        n = (int)rectangle2D.getX();
        int n5 = (int)rectangle2D.getY();
        int n6 = (int)rectangle2D.getWidth() / n4;
        int n7 = (int)rectangle2D.getHeight() / n2;
        int n8 = 0;
        int n9 = 0;
        int n10 = n2 * n4 - n3;
        int n11 = 0;
        Rectangle rectangle = new Rectangle();
        for (int i = 0; i < n3; ++i) {
            rectangle.setBounds(n + n11 + n6 * n9, n5 + n7 * n8, n6, n7);
            String string = null;
            string = this.dataExtractOrder == TableOrder.BY_ROW ? this.dataset.getRowKey(i).toString() : this.dataset.getColumnKey(i).toString();
            this.pieChart.setTitle(string);
            PieDataset pieDataset = null;
            CategoryToPieDataset categoryToPieDataset = new CategoryToPieDataset(this.dataset, this.dataExtractOrder, i);
            pieDataset = this.limit > 0.0 ? DatasetUtilities.createConsolidatedPieDataset(categoryToPieDataset, (Comparable)((Object)"Other"), this.limit) : categoryToPieDataset;
            PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
            piePlot.setDataset(pieDataset);
            piePlot.setPieIndex(i);
            ChartRenderingInfo chartRenderingInfo = null;
            if (plotRenderingInfo != null) {
                chartRenderingInfo = new ChartRenderingInfo();
            }
            this.pieChart.draw(graphics2D, rectangle, chartRenderingInfo);
            if (plotRenderingInfo != null) {
                plotRenderingInfo.getOwner().getEntityCollection().addAll(chartRenderingInfo.getEntityCollection());
                plotRenderingInfo.addSubplotInfo(chartRenderingInfo.getPlotInfo());
            }
            if (++n9 != n4) continue;
            n9 = 0;
            if (++n8 != n2 - 1 || n10 == 0) continue;
            n11 = n10 * n6 / 2;
        }
    }

    public LegendItemCollection getLegendItems() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        if (this.dataset != null) {
            List list = null;
            if (this.dataExtractOrder == TableOrder.BY_ROW) {
                list = this.dataset.getColumnKeys();
            } else if (this.dataExtractOrder == TableOrder.BY_COLUMN) {
                list = this.dataset.getRowKeys();
            }
            if (list != null) {
                int n = 0;
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    String string;
                    String string2 = string = iterator.next().toString();
                    PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
                    Paint paint = piePlot.getSectionPaint(n);
                    Paint paint2 = piePlot.getSectionOutlinePaint(n);
                    Stroke stroke = piePlot.getSectionOutlineStroke(n);
                    LegendItem legendItem = new LegendItem(string, string2, null, null, Plot.DEFAULT_LEGEND_ITEM_CIRCLE, paint, stroke, paint2);
                    legendItemCollection.add(legendItem);
                    ++n;
                }
            }
        }
        return legendItemCollection;
    }
}

