/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.labels.IntervalCategoryItemLabelGenerator;

public class IntervalCategoryLabelGeneratorTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(IntervalCategoryLabelGeneratorTests.class);
    }

    public IntervalCategoryLabelGeneratorTests(String string) {
        super(string);
    }

    public void testEquals() {
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator2 = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)intervalCategoryItemLabelGenerator2.equals(intervalCategoryItemLabelGenerator));
        intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        IntervalCategoryLabelGeneratorTests.assertFalse((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
        intervalCategoryItemLabelGenerator2 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new DecimalFormat("0.000"));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
        intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        IntervalCategoryLabelGeneratorTests.assertFalse((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
        intervalCategoryItemLabelGenerator2 = new IntervalCategoryItemLabelGenerator("{3} - {4}", new SimpleDateFormat("d-MMM"));
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
    }

    public void testCloning() {
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator();
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator2 = null;
        try {
            intervalCategoryItemLabelGenerator2 = (IntervalCategoryItemLabelGenerator)intervalCategoryItemLabelGenerator.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        IntervalCategoryLabelGeneratorTests.assertTrue((intervalCategoryItemLabelGenerator != intervalCategoryItemLabelGenerator2 ? 1 : 0) != 0);
        IntervalCategoryLabelGeneratorTests.assertTrue((intervalCategoryItemLabelGenerator.getClass() == intervalCategoryItemLabelGenerator2.getClass() ? 1 : 0) != 0);
        IntervalCategoryLabelGeneratorTests.assertTrue((boolean)intervalCategoryItemLabelGenerator.equals(intervalCategoryItemLabelGenerator2));
    }

    public void testSerialization() {
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator = new IntervalCategoryItemLabelGenerator("{3} - {4}", DateFormat.getInstance());
        IntervalCategoryItemLabelGenerator intervalCategoryItemLabelGenerator2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(intervalCategoryItemLabelGenerator);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            intervalCategoryItemLabelGenerator2 = (IntervalCategoryItemLabelGenerator)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        IntervalCategoryLabelGeneratorTests.assertEquals((Object)intervalCategoryItemLabelGenerator, intervalCategoryItemLabelGenerator2);
    }
}

