/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.labels;

import java.io.Serializable;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XisSymbolic;
import org.jfree.data.xy.YisSymbolic;
import org.jfree.util.PublicCloneable;

public class SymbolicXYItemLabelGenerator
implements XYItemLabelGenerator,
XYToolTipGenerator,
Cloneable,
PublicCloneable,
Serializable {
    private static final long serialVersionUID = 3963400354475494395L;

    public String generateToolTip(XYDataset xYDataset, int n, int n2) {
        String string;
        double d;
        String string2;
        if (xYDataset instanceof YisSymbolic) {
            string2 = ((YisSymbolic)((Object)xYDataset)).getYSymbolicValue(n, n2);
        } else {
            d = xYDataset.getYValue(n, n2);
            string2 = Double.toString(SymbolicXYItemLabelGenerator.round(d, 2));
        }
        if (xYDataset instanceof XisSymbolic) {
            string = ((XisSymbolic)((Object)xYDataset)).getXSymbolicValue(n, n2);
        } else if (xYDataset instanceof TimeSeriesCollection) {
            RegularTimePeriod regularTimePeriod = ((TimeSeriesCollection)xYDataset).getSeries(n).getTimePeriod(n2);
            string = regularTimePeriod.toString();
        } else {
            d = xYDataset.getXValue(n, n2);
            string = Double.toString(SymbolicXYItemLabelGenerator.round(d, 2));
        }
        return "X: " + string + ", Y: " + string2;
    }

    public String generateLabel(XYDataset xYDataset, int n, int n2) {
        return null;
    }

    private static double round(double d, int n) {
        if (n <= 0) {
            return Math.floor(d + 0.5);
        }
        double d2 = Math.pow(10.0, n);
        double d3 = Math.floor(d * d2 + 0.5);
        return d3 / d2;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        return object instanceof SymbolicXYItemLabelGenerator;
    }
}

