/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class PieChart3DTests
extends TestCase {
    private JFreeChart pieChart;

    public static Test suite() {
        return new TestSuite(PieChart3DTests.class);
    }

    public PieChart3DTests(String string) {
        super(string);
    }

    protected void setUp() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Visual Basic"), new Double(0.0));
        defaultPieDataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        this.pieChart = PieChart3DTests.createPieChart3D(defaultPieDataset);
    }

    public void testReplaceDatasetOnPieChart() {
        LocalListener localListener = new LocalListener();
        this.pieChart.addChangeListener(localListener);
        PiePlot piePlot = (PiePlot)this.pieChart.getPlot();
        piePlot.setDataset(null);
        PieChart3DTests.assertEquals((boolean)true, (boolean)localListener.flag);
        PieChart3DTests.assertNull((Object)piePlot.getDataset());
    }

    public void testNullValueInDataset() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Section 1"), 10.0);
        defaultPieDataset.setValue((Comparable)((Object)"Section 2"), 11.0);
        defaultPieDataset.setValue((Comparable)((Object)"Section 3"), null);
        JFreeChart jFreeChart = PieChart3DTests.createPieChart3D(defaultPieDataset);
        boolean bl = false;
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            jFreeChart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            graphics2D.dispose();
            bl = true;
        }
        catch (Throwable throwable) {
            bl = false;
        }
        PieChart3DTests.assertTrue((boolean)bl);
    }

    private static JFreeChart createPieChart3D(PieDataset pieDataset) {
        return ChartFactory.createPieChart3D("Pie Chart", pieDataset, true, true, false);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

