/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;

public class LegendItemCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(LegendItemCollectionTests.class);
    }

    public LegendItemCollectionTests(String string) {
        super(string);
    }

    public void testEquals() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        LegendItemCollection legendItemCollection2 = new LegendItemCollection();
        LegendItemCollectionTests.assertTrue((boolean)legendItemCollection.equals(legendItemCollection2));
        LegendItemCollectionTests.assertTrue((boolean)legendItemCollection2.equals(legendItemCollection));
        LegendItem legendItem = new LegendItem("Label", "Description", "ToolTip", "URL", true, new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), true, Color.red, true, Color.blue, new BasicStroke(1.2f), true, new Line2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(2.1f), Color.green);
        LegendItem legendItem2 = new LegendItem("Label", "Description", "ToolTip", "URL", true, new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), true, Color.red, true, Color.blue, new BasicStroke(1.2f), true, new Line2D.Double(1.0, 2.0, 3.0, 4.0), new BasicStroke(2.1f), Color.green);
        legendItemCollection.add(legendItem);
        legendItemCollection2.add(legendItem2);
        LegendItemCollectionTests.assertTrue((boolean)legendItemCollection.equals(legendItemCollection2));
    }

    public void testSerialization() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        legendItemCollection.add(new LegendItem("Item", "Description", "ToolTip", "URL", new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), Color.red));
        LegendItemCollection legendItemCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(legendItemCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            legendItemCollection2 = (LegendItemCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        LegendItemCollectionTests.assertEquals((Object)legendItemCollection, legendItemCollection2);
    }

    public void testCloning() {
        LegendItemCollection legendItemCollection = new LegendItemCollection();
        legendItemCollection.add(new LegendItem("Item", "Description", "ToolTip", "URL", new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), Color.red));
        LegendItemCollection legendItemCollection2 = null;
        try {
            legendItemCollection2 = (LegendItemCollection)legendItemCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        LegendItemCollectionTests.assertTrue((legendItemCollection != legendItemCollection2 ? 1 : 0) != 0);
        LegendItemCollectionTests.assertTrue((legendItemCollection.getClass() == legendItemCollection2.getClass() ? 1 : 0) != 0);
        LegendItemCollectionTests.assertTrue((boolean)legendItemCollection.equals(legendItemCollection2));
    }
}

