/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;

public class JFreeChartTests
extends TestCase {
    private JFreeChart pieChart;

    public static Test suite() {
        return new TestSuite(JFreeChartTests.class);
    }

    public JFreeChartTests(String string) {
        super(string);
    }

    protected void setUp() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Java"), new Double(43.2));
        defaultPieDataset.setValue((Comparable)((Object)"Visual Basic"), new Double(0.0));
        defaultPieDataset.setValue((Comparable)((Object)"C/C++"), new Double(17.5));
        this.pieChart = ChartFactory.createPieChart("Pie Chart", defaultPieDataset, true, true, false);
    }

    public void testSubtitleCount() {
        int n = this.pieChart.getSubtitleCount();
        JFreeChartTests.assertEquals((int)1, (int)n);
    }

    public void testSerialization1() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Type 1"), 54.5);
        defaultPieDataset.setValue((Comparable)((Object)"Type 2"), 23.9);
        defaultPieDataset.setValue((Comparable)((Object)"Type 3"), 45.8);
        JFreeChart jFreeChart = ChartFactory.createPieChart("Test", defaultPieDataset, true, true, true);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFreeChartTests.assertEquals((Object)jFreeChart, jFreeChart2);
    }

    public void testSerialization2() {
        DefaultPieDataset defaultPieDataset = new DefaultPieDataset();
        defaultPieDataset.setValue((Comparable)((Object)"Type 1"), 54.5);
        defaultPieDataset.setValue((Comparable)((Object)"Type 2"), 23.9);
        defaultPieDataset.setValue((Comparable)((Object)"Type 3"), 45.8);
        JFreeChart jFreeChart = ChartFactory.createPieChart3D("Test", defaultPieDataset, true, true, true);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFreeChartTests.assertEquals((Object)jFreeChart, jFreeChart2);
    }

    public void testSerialization3() {
        String string = "First";
        String string2 = "Second";
        String string3 = "Third";
        String string4 = "Category 1";
        String string5 = "Category 2";
        String string6 = "Category 3";
        String string7 = "Category 4";
        String string8 = "Category 5";
        String string9 = "Category 6";
        String string10 = "Category 7";
        String string11 = "Category 8";
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)string), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string), (Comparable)((Object)string10));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)string), (Comparable)((Object)string11));
        defaultCategoryDataset.addValue(5.0, (Comparable)((Object)string2), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(7.0, (Comparable)((Object)string2), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)string2), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(8.0, (Comparable)((Object)string2), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string2), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string2), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)string2), (Comparable)((Object)string10));
        defaultCategoryDataset.addValue(1.0, (Comparable)((Object)string2), (Comparable)((Object)string11));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string3), (Comparable)((Object)string4));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string3), (Comparable)((Object)string5));
        defaultCategoryDataset.addValue(2.0, (Comparable)((Object)string3), (Comparable)((Object)string6));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string3), (Comparable)((Object)string7));
        defaultCategoryDataset.addValue(6.0, (Comparable)((Object)string3), (Comparable)((Object)string8));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string3), (Comparable)((Object)string9));
        defaultCategoryDataset.addValue(4.0, (Comparable)((Object)string3), (Comparable)((Object)string10));
        defaultCategoryDataset.addValue(3.0, (Comparable)((Object)string3), (Comparable)((Object)string11));
        JFreeChart jFreeChart = ChartFactory.createBarChart("Vertical Bar Chart", "Category", "Value", defaultCategoryDataset, PlotOrientation.VERTICAL, true, true, false);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFreeChartTests.assertEquals((Object)jFreeChart, jFreeChart2);
    }

    public void testSerialization4() {
        RegularTimePeriod regularTimePeriod = new Day();
        TimeSeries timeSeries = new TimeSeries("Series 1");
        timeSeries.add(regularTimePeriod, 36.4);
        regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
        timeSeries.add(regularTimePeriod, 63.5);
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        timeSeriesCollection.addSeries(timeSeries);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Test", "Date", "Value", timeSeriesCollection, true, true, true);
        JFreeChart jFreeChart2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(jFreeChart);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            jFreeChart2 = (JFreeChart)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        JFreeChartTests.assertEquals((Object)jFreeChart, jFreeChart2);
    }
}

