/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Calendar;
import java.util.Date;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;

public class GanttChartTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(GanttChartTests.class);
    }

    public GanttChartTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.chart = GanttChartTests.createGanttChart();
    }

    public void testDrawWithNullInfo() {
        boolean bl = false;
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.chart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            graphics2D.dispose();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        GanttChartTests.assertTrue((boolean)bl);
    }

    public void testReplaceDataset() {
        LocalListener localListener = new LocalListener();
        this.chart.addChangeListener(localListener);
        this.chart.getCategoryPlot().setDataset(null);
        GanttChartTests.assertEquals((boolean)true, (boolean)localListener.flag);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        categoryItemRenderer.setSeriesToolTipGenerator(0, standardCategoryToolTipGenerator);
        CategoryToolTipGenerator categoryToolTipGenerator = categoryItemRenderer.getToolTipGenerator(0, 0);
        GanttChartTests.assertTrue((categoryToolTipGenerator == standardCategoryToolTipGenerator ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryURLGenerator standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        categoryItemRenderer.setSeriesItemURLGenerator(0, standardCategoryURLGenerator);
        CategoryURLGenerator categoryURLGenerator = categoryItemRenderer.getItemURLGenerator(0, 0);
        GanttChartTests.assertTrue((categoryURLGenerator == standardCategoryURLGenerator ? 1 : 0) != 0);
    }

    private static JFreeChart createGanttChart() {
        return ChartFactory.createGanttChart("Gantt Chart", "Domain", "Range", null, true, true, true);
    }

    public static IntervalCategoryDataset createDataset() {
        TaskSeries taskSeries = new TaskSeries("Scheduled");
        taskSeries.add(new Task("Write Proposal", new SimpleTimePeriod(GanttChartTests.date(1, 3, 2001), GanttChartTests.date(5, 3, 2001))));
        taskSeries.add(new Task("Obtain Approval", new SimpleTimePeriod(GanttChartTests.date(9, 3, 2001), GanttChartTests.date(9, 3, 2001))));
        taskSeries.add(new Task("Requirements Analysis", new SimpleTimePeriod(GanttChartTests.date(10, 3, 2001), GanttChartTests.date(5, 4, 2001))));
        taskSeries.add(new Task("Design Phase", new SimpleTimePeriod(GanttChartTests.date(6, 4, 2001), GanttChartTests.date(30, 4, 2001))));
        taskSeries.add(new Task("Design Signoff", new SimpleTimePeriod(GanttChartTests.date(2, 5, 2001), GanttChartTests.date(2, 5, 2001))));
        taskSeries.add(new Task("Alpha Implementation", new SimpleTimePeriod(GanttChartTests.date(3, 5, 2001), GanttChartTests.date(31, 6, 2001))));
        taskSeries.add(new Task("Design Review", new SimpleTimePeriod(GanttChartTests.date(1, 7, 2001), GanttChartTests.date(8, 7, 2001))));
        taskSeries.add(new Task("Revised Design Signoff", new SimpleTimePeriod(GanttChartTests.date(10, 7, 2001), GanttChartTests.date(10, 7, 2001))));
        taskSeries.add(new Task("Beta Implementation", new SimpleTimePeriod(GanttChartTests.date(12, 7, 2001), GanttChartTests.date(12, 8, 2001))));
        taskSeries.add(new Task("Testing", new SimpleTimePeriod(GanttChartTests.date(13, 8, 2001), GanttChartTests.date(31, 9, 2001))));
        taskSeries.add(new Task("Final Implementation", new SimpleTimePeriod(GanttChartTests.date(1, 10, 2001), GanttChartTests.date(15, 10, 2001))));
        taskSeries.add(new Task("Signoff", new SimpleTimePeriod(GanttChartTests.date(28, 10, 2001), GanttChartTests.date(30, 10, 2001))));
        TaskSeries taskSeries2 = new TaskSeries("Actual");
        taskSeries2.add(new Task("Write Proposal", new SimpleTimePeriod(GanttChartTests.date(1, 3, 2001), GanttChartTests.date(5, 3, 2001))));
        taskSeries2.add(new Task("Obtain Approval", new SimpleTimePeriod(GanttChartTests.date(9, 3, 2001), GanttChartTests.date(9, 3, 2001))));
        taskSeries2.add(new Task("Requirements Analysis", new SimpleTimePeriod(GanttChartTests.date(10, 3, 2001), GanttChartTests.date(15, 4, 2001))));
        taskSeries2.add(new Task("Design Phase", new SimpleTimePeriod(GanttChartTests.date(15, 4, 2001), GanttChartTests.date(17, 5, 2001))));
        taskSeries2.add(new Task("Design Signoff", new SimpleTimePeriod(GanttChartTests.date(30, 5, 2001), GanttChartTests.date(30, 5, 2001))));
        taskSeries2.add(new Task("Alpha Implementation", new SimpleTimePeriod(GanttChartTests.date(1, 6, 2001), GanttChartTests.date(12, 8, 2001))));
        taskSeries2.add(new Task("Design Review", new SimpleTimePeriod(GanttChartTests.date(12, 8, 2001), GanttChartTests.date(22, 8, 2001))));
        taskSeries2.add(new Task("Revised Design Signoff", new SimpleTimePeriod(GanttChartTests.date(25, 8, 2001), GanttChartTests.date(27, 8, 2001))));
        taskSeries2.add(new Task("Beta Implementation", new SimpleTimePeriod(GanttChartTests.date(27, 8, 2001), GanttChartTests.date(30, 9, 2001))));
        taskSeries2.add(new Task("Testing", new SimpleTimePeriod(GanttChartTests.date(31, 9, 2001), GanttChartTests.date(17, 10, 2001))));
        taskSeries2.add(new Task("Final Implementation", new SimpleTimePeriod(GanttChartTests.date(18, 10, 2001), GanttChartTests.date(5, 11, 2001))));
        taskSeries2.add(new Task("Signoff", new SimpleTimePeriod(GanttChartTests.date(10, 11, 2001), GanttChartTests.date(11, 11, 2001))));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        return taskSeriesCollection;
    }

    private static Date date(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n2, n);
        Date date = calendar.getTime();
        return date;
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

