/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartRenderingInfo;

public class ChartRenderingInfoTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(ChartRenderingInfoTests.class);
    }

    public ChartRenderingInfoTests(String string) {
        super(string);
    }

    public void testEquals() {
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        ChartRenderingInfo chartRenderingInfo2 = new ChartRenderingInfo();
        ChartRenderingInfoTests.assertTrue((boolean)chartRenderingInfo.equals(chartRenderingInfo2));
    }

    public void testCloning() {
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        ChartRenderingInfo chartRenderingInfo2 = null;
        try {
            chartRenderingInfo2 = (ChartRenderingInfo)chartRenderingInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        ChartRenderingInfoTests.assertTrue((chartRenderingInfo != chartRenderingInfo2 ? 1 : 0) != 0);
        ChartRenderingInfoTests.assertTrue((chartRenderingInfo.getClass() == chartRenderingInfo2.getClass() ? 1 : 0) != 0);
        ChartRenderingInfoTests.assertTrue((boolean)chartRenderingInfo.equals(chartRenderingInfo2));
    }

    public void testSerialization() {
        ChartRenderingInfo chartRenderingInfo = new ChartRenderingInfo();
        ChartRenderingInfo chartRenderingInfo2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(chartRenderingInfo);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            chartRenderingInfo2 = (ChartRenderingInfo)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        ChartRenderingInfoTests.assertEquals((Object)chartRenderingInfo, chartRenderingInfo2);
    }
}

