/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.junit;

import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.event.ChartChangeEvent;
import org.jfree.chart.event.ChartChangeListener;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.urls.CategoryURLGenerator;
import org.jfree.chart.urls.StandardCategoryURLGenerator;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;

public class BarChart3DTests
extends TestCase {
    private JFreeChart chart;

    public static Test suite() {
        return new TestSuite(BarChart3DTests.class);
    }

    public BarChart3DTests(String string) {
        super(string);
    }

    protected void setUp() {
        this.chart = BarChart3DTests.createBarChart3D();
    }

    public void testDrawWithNullInfo() {
        boolean bl = false;
        try {
            BufferedImage bufferedImage = new BufferedImage(200, 100, 1);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            this.chart.draw(graphics2D, new Rectangle2D.Double(0.0, 0.0, 200.0, 100.0), null, null);
            graphics2D.dispose();
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        BarChart3DTests.assertTrue((boolean)bl);
    }

    public void testReplaceDataset() {
        Number[][] numberArray = new Integer[][]{{new Integer(-30), new Integer(-20)}, {new Integer(-10), new Integer(10)}, {new Integer(20), new Integer(30)}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("S", "C", numberArray);
        LocalListener localListener = new LocalListener();
        this.chart.addChangeListener(localListener);
        this.chart.getCategoryPlot().setDataset(categoryDataset);
        BarChart3DTests.assertEquals((boolean)true, (boolean)localListener.flag);
        ValueAxis valueAxis = this.chart.getCategoryPlot().getRangeAxis();
        Range range = valueAxis.getRange();
        BarChart3DTests.assertTrue((String)("Expecting the lower bound of the range to be around -30: " + range.getLowerBound()), (range.getLowerBound() <= -30.0 ? 1 : 0) != 0);
        BarChart3DTests.assertTrue((String)("Expecting the upper bound of the range to be around 30: " + range.getUpperBound()), (range.getUpperBound() >= 30.0 ? 1 : 0) != 0);
    }

    public void testSetSeriesToolTipGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryToolTipGenerator standardCategoryToolTipGenerator = new StandardCategoryToolTipGenerator();
        categoryItemRenderer.setSeriesToolTipGenerator(0, standardCategoryToolTipGenerator);
        CategoryToolTipGenerator categoryToolTipGenerator = categoryItemRenderer.getToolTipGenerator(0, 0);
        BarChart3DTests.assertTrue((categoryToolTipGenerator == standardCategoryToolTipGenerator ? 1 : 0) != 0);
    }

    public void testSetSeriesURLGenerator() {
        CategoryPlot categoryPlot = (CategoryPlot)this.chart.getPlot();
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        StandardCategoryURLGenerator standardCategoryURLGenerator = new StandardCategoryURLGenerator();
        categoryItemRenderer.setSeriesItemURLGenerator(0, standardCategoryURLGenerator);
        CategoryURLGenerator categoryURLGenerator = categoryItemRenderer.getItemURLGenerator(0, 0);
        BarChart3DTests.assertTrue((categoryURLGenerator == standardCategoryURLGenerator ? 1 : 0) != 0);
    }

    private static JFreeChart createBarChart3D() {
        Number[][] numberArray = new Integer[][]{{new Integer(-3), new Integer(-2)}, {new Integer(-1), new Integer(1)}, {new Integer(2), new Integer(3)}};
        CategoryDataset categoryDataset = DatasetUtilities.createCategoryDataset("S", "C", numberArray);
        return ChartFactory.createBarChart3D("Bar Chart 3D", "Domain", "Range", categoryDataset, PlotOrientation.HORIZONTAL, true, true, true);
    }

    static class LocalListener
    implements ChartChangeListener {
        private boolean flag = false;

        LocalListener() {
        }

        public void chartChanged(ChartChangeEvent chartChangeEvent) {
            this.flag = true;
        }
    }
}

