/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.XYItemEntity;
import org.jfree.data.time.TimeSeriesCollection;

public class XYItemEntityTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(XYItemEntityTests.class);
    }

    public XYItemEntityTests(String string) {
        super(string);
    }

    public void testEquals() {
        XYItemEntity xYItemEntity = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity xYItemEntity2 = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        XYItemEntityTests.assertFalse((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity2.setArea(new Rectangle2D.Double(4.0, 3.0, 2.0, 1.0));
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity.setToolTipText("New ToolTip");
        XYItemEntityTests.assertFalse((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity2.setToolTipText("New ToolTip");
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity.setURLText("New URL");
        XYItemEntityTests.assertFalse((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity2.setURLText("New URL");
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity.setSeriesIndex(88);
        XYItemEntityTests.assertFalse((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity2.setSeriesIndex(88);
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity.setItem(88);
        XYItemEntityTests.assertFalse((boolean)xYItemEntity.equals(xYItemEntity2));
        xYItemEntity2.setItem(88);
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
    }

    public void testCloning() {
        XYItemEntity xYItemEntity = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity xYItemEntity2 = null;
        try {
            xYItemEntity2 = (XYItemEntity)xYItemEntity.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        XYItemEntityTests.assertTrue((xYItemEntity != xYItemEntity2 ? 1 : 0) != 0);
        XYItemEntityTests.assertTrue((xYItemEntity.getClass() == xYItemEntity2.getClass() ? 1 : 0) != 0);
        XYItemEntityTests.assertTrue((boolean)xYItemEntity.equals(xYItemEntity2));
    }

    public void testSerialization() {
        XYItemEntity xYItemEntity = new XYItemEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new TimeSeriesCollection(), 1, 9, "ToolTip", "URL");
        XYItemEntity xYItemEntity2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(xYItemEntity);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            xYItemEntity2 = (XYItemEntity)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        XYItemEntityTests.assertEquals((Object)xYItemEntity, xYItemEntity2);
    }
}

