/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.entity.junit;

import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.chart.entity.PieSectionEntity;
import org.jfree.chart.entity.StandardEntityCollection;
import org.jfree.data.general.DefaultPieDataset;

public class StandardEntityCollectionTests
extends TestCase {
    public static Test suite() {
        return new TestSuite(StandardEntityCollectionTests.class);
    }

    public StandardEntityCollectionTests(String string) {
        super(string);
    }

    public void testEquals() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection standardEntityCollection = new StandardEntityCollection();
        standardEntityCollection.add(pieSectionEntity);
        PieSectionEntity pieSectionEntity2 = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection standardEntityCollection2 = new StandardEntityCollection();
        standardEntityCollection2.add(pieSectionEntity2);
        StandardEntityCollectionTests.assertTrue((boolean)standardEntityCollection.equals(standardEntityCollection2));
    }

    public void testCloning() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection standardEntityCollection = new StandardEntityCollection();
        standardEntityCollection.add(pieSectionEntity);
        StandardEntityCollection standardEntityCollection2 = null;
        try {
            standardEntityCollection2 = (StandardEntityCollection)standardEntityCollection.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            System.err.println("Failed to clone.");
        }
        StandardEntityCollectionTests.assertTrue((standardEntityCollection != standardEntityCollection2 ? 1 : 0) != 0);
        StandardEntityCollectionTests.assertTrue((standardEntityCollection.getClass() == standardEntityCollection2.getClass() ? 1 : 0) != 0);
        StandardEntityCollectionTests.assertTrue((boolean)standardEntityCollection.equals(standardEntityCollection2));
    }

    public void testSerialization() {
        PieSectionEntity pieSectionEntity = new PieSectionEntity(new Rectangle2D.Double(1.0, 2.0, 3.0, 4.0), new DefaultPieDataset(), 0, 1, (Comparable)((Object)"Key"), "ToolTip", "URL");
        StandardEntityCollection standardEntityCollection = new StandardEntityCollection();
        standardEntityCollection.add(pieSectionEntity);
        StandardEntityCollection standardEntityCollection2 = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(standardEntityCollection);
            objectOutputStream.close();
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            standardEntityCollection2 = (StandardEntityCollection)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        StandardEntityCollectionTests.assertEquals((Object)standardEntityCollection, standardEntityCollection2);
    }
}

