/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.Axis;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.SymbolicAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYTickLabelDemo
extends ApplicationFrame
implements ActionListener {
    private static final int DEFAULT_FONT_SIZE = 13;
    private JFreeChart chart = this.createChart();
    private JCheckBox verticalTickLabelsCheckBox;
    private JCheckBox horizontalPlotCheckBox;
    private JCheckBox symbolicAxesCheckBox;
    private JTextField fontSizeTextField;

    public XYTickLabelDemo(String string) {
        super(string);
        ChartPanel chartPanel = new ChartPanel(this.chart);
        chartPanel.setPreferredSize(new Dimension(600, 270));
        JPanel jPanel = new JPanel(new BorderLayout());
        this.setContentPane(jPanel);
        jPanel.add(chartPanel);
        JPanel jPanel2 = new JPanel();
        jPanel.add((Component)jPanel2, "South");
        this.symbolicAxesCheckBox = new JCheckBox("Symbolic axes");
        this.symbolicAxesCheckBox.addActionListener(this);
        jPanel2.add(this.symbolicAxesCheckBox);
        this.verticalTickLabelsCheckBox = new JCheckBox("Tick labels vertical");
        this.verticalTickLabelsCheckBox.addActionListener(this);
        jPanel2.add(this.verticalTickLabelsCheckBox);
        this.fontSizeTextField = new JTextField(3);
        this.fontSizeTextField.addActionListener(this);
        jPanel2.add(new JLabel("Font size:"));
        jPanel2.add(this.fontSizeTextField);
        ValueAxis valueAxis = this.chart.getXYPlot().getDomainAxis();
        this.fontSizeTextField.setText("13");
        XYPlot xYPlot = this.chart.getXYPlot();
        Font font = valueAxis.getTickLabelFont();
        font = font.deriveFont(13.0f);
        xYPlot.getDomainAxis().setTickLabelFont(font);
        xYPlot.getRangeAxis().setTickLabelFont(font);
        xYPlot.getDomainAxis(1).setTickLabelFont(font);
        xYPlot.getRangeAxis(1).setTickLabelFont(font);
        this.horizontalPlotCheckBox = new JCheckBox("Plot horizontal");
        this.horizontalPlotCheckBox.addActionListener(this);
        jPanel2.add(this.horizontalPlotCheckBox);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string;
            Object object;
            Object object2;
            ValueAxis[] valueAxisArray;
            block7: {
                block5: {
                    int n;
                    boolean bl;
                    valueAxisArray = new ValueAxis[4];
                    XYPlot xYPlot = this.chart.getXYPlot();
                    valueAxisArray[0] = xYPlot.getDomainAxis();
                    valueAxisArray[1] = xYPlot.getRangeAxis();
                    valueAxisArray[2] = xYPlot.getDomainAxis(1);
                    valueAxisArray[3] = xYPlot.getRangeAxis(1);
                    object2 = actionEvent.getSource();
                    if (object2 == this.symbolicAxesCheckBox) {
                        bl = this.symbolicAxesCheckBox.isSelected();
                        for (n = 0; n < valueAxisArray.length; ++n) {
                            ValueAxis valueAxis = valueAxisArray[n];
                            object = valueAxis.getLabel();
                            int n2 = (int)valueAxis.getUpperBound();
                            String[] stringArray = new String[n2];
                            Font font = valueAxis.getTickLabelFont();
                            for (int i = 0; i < n2; ++i) {
                                stringArray[i] = "Label " + i;
                            }
                            valueAxis = bl ? new SymbolicAxis((String)object, stringArray) : new NumberAxis((String)object);
                            valueAxis.setTickLabelFont(font);
                            valueAxisArray[n] = valueAxis;
                        }
                        xYPlot.setDomainAxis(valueAxisArray[0]);
                        xYPlot.setRangeAxis(valueAxisArray[1]);
                        xYPlot.setDomainAxis(1, valueAxisArray[2]);
                        xYPlot.setRangeAxis(1, valueAxisArray[3]);
                    }
                    if (object2 != this.symbolicAxesCheckBox && object2 != this.verticalTickLabelsCheckBox) break block5;
                    bl = this.verticalTickLabelsCheckBox.isSelected();
                    for (n = 0; n < valueAxisArray.length; ++n) {
                        valueAxisArray[n].setVerticalTickLabels(bl);
                    }
                    break block6;
                }
                if (object2 != this.symbolicAxesCheckBox && object2 != this.horizontalPlotCheckBox) break block7;
                PlotOrientation plotOrientation = this.horizontalPlotCheckBox.isSelected() ? PlotOrientation.HORIZONTAL : PlotOrientation.VERTICAL;
                this.chart.getXYPlot().setOrientation(plotOrientation);
                break block6;
            }
            if (object2 != this.symbolicAxesCheckBox && object2 != this.fontSizeTextField || (string = this.fontSizeTextField.getText()).length() <= 0) break block6;
            float f = Float.parseFloat(string);
            for (int i = 0; i < valueAxisArray.length; ++i) {
                object = valueAxisArray[i];
                Font font = ((Axis)object).getTickLabelFont();
                font = font.deriveFont(f);
                ((Axis)object).setTickLabelFont(font);
            }
        }
    }

    private JFreeChart createChart() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Something"));
        xYSeries.add(0.0, 30.0);
        xYSeries.add(1.0, 10.0);
        xYSeries.add(2.0, 40.0);
        xYSeries.add(3.0, 30.0);
        xYSeries.add(4.0, 50.0);
        xYSeries.add(5.0, 50.0);
        xYSeries.add(6.0, 70.0);
        xYSeries.add(7.0, 70.0);
        xYSeries.add(8.0, 80.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Something else"));
        xYSeries2.add(0.0, 5.0);
        xYSeries2.add(1.0, 4.0);
        xYSeries2.add(2.0, 1.0);
        xYSeries2.add(3.0, 5.0);
        xYSeries2.add(4.0, 0.0);
        XYSeriesCollection xYSeriesCollection2 = new XYSeriesCollection();
        xYSeriesCollection2.addSeries(xYSeries2);
        JFreeChart jFreeChart = ChartFactory.createXYLineChart("Tick Label Demo", "Domain Axis 1", "Range Axis 1", xYSeriesCollection, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setOrientation(PlotOrientation.VERTICAL);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        StandardXYItemRenderer standardXYItemRenderer = (StandardXYItemRenderer)xYPlot.getRenderer();
        standardXYItemRenderer.setPaint(Color.black);
        NumberAxis numberAxis = new NumberAxis("Domain Axis 2");
        numberAxis.setAutoRangeIncludesZero(false);
        xYPlot.setDomainAxis(1, numberAxis);
        DateAxis dateAxis = new DateAxis("Range Axis 1");
        xYPlot.setRangeAxis(dateAxis);
        DateAxis dateAxis2 = new DateAxis("Range Axis 2");
        xYPlot.setRangeAxis(1, dateAxis2);
        xYPlot.setRangeAxisLocation(1, AxisLocation.BOTTOM_OR_RIGHT);
        xYPlot.setDataset(1, xYSeriesCollection2);
        xYPlot.mapDatasetToDomainAxis(1, 1);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        XYTickLabelDemo xYTickLabelDemo = new XYTickLabelDemo("Tick Label Demo");
        xYTickLabelDemo.pack();
        RefineryUtilities.centerFrameOnScreen(xYTickLabelDemo);
        xYTickLabelDemo.setVisible(true);
    }
}

