/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.Color;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.date.DateUtilities;
import org.jfree.ui.RefineryUtilities;

public class XYStepChartDemo {
    private ChartFrame frame = null;

    private void displayChart() {
        if (this.frame == null) {
            XYDataset xYDataset = XYStepChartDemo.createStepXYDataset();
            JFreeChart jFreeChart = ChartFactory.createXYStepChart("LCACs in use at given time", "Time", "Number of Transports", xYDataset, PlotOrientation.VERTICAL, true, true, false);
            jFreeChart.setBackgroundPaint(new Color(216, 216, 216));
            XYPlot xYPlot = jFreeChart.getXYPlot();
            xYPlot.getRenderer().setSeriesStroke(0, new BasicStroke(2.0f));
            xYPlot.getRenderer().setSeriesStroke(1, new BasicStroke(2.0f));
            this.frame = new ChartFrame("Plan Comparison", jFreeChart);
            this.frame.pack();
            RefineryUtilities.positionFrameRandomly(this.frame);
            this.frame.setVisible(true);
        } else {
            this.frame.setVisible(true);
            this.frame.requestFocus();
        }
    }

    public static XYDataset createStepXYDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Plan 1"), false, true);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 8, 0).getTime(), 0.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 8, 1).getTime(), 2.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 9, 5).getTime(), 4.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 10, 6).getTime(), 4.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 11, 6).getTime(), 5.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 12, 6).getTime(), 3.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 13, 6).getTime(), 6.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 14, 6).getTime(), 6.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 15, 30).getTime(), 2.0);
        xYSeries.add((double)DateUtilities.createDate(2002, 2, 19, 16, 7).getTime(), 0.0);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Plan 2"));
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 8, 40).getTime(), 0.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 8, 45).getTime(), 1.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 9, 0).getTime(), 6.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 10, 6).getTime(), 2.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 10, 45).getTime(), 4.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 12, 0).getTime(), 7.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 13, 0).getTime(), 5.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 14, 6).getTime(), 4.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 15, 15).getTime(), 4.0);
        xYSeries2.add((double)DateUtilities.createDate(2002, 2, 19, 16, 0).getTime(), 0.0);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        return xYSeriesCollection;
    }

    public static void main(String[] stringArray) {
        XYStepChartDemo xYStepChartDemo = new XYStepChartDemo();
        xYStepChartDemo.displayChart();
    }
}

