/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYStepAreaChartDemo
extends ApplicationFrame
implements ActionListener {
    private static final String ORIENT_VERT = "Plot vertical";
    private static final String ORIENT_HORIZ = "Plot horizontal";
    private static final Object[][] TEST_DATA = new Object[][]{{new Integer(1), new Integer(500), Boolean.TRUE}, {new Integer(2), new Integer(694)}, {new Integer(3), new Integer(-734)}, {new Integer(4), new Integer(453)}, {new Integer(5), new Integer(500), Boolean.TRUE}, {new Integer(6), new Integer(200)}, {new Integer(7), new Integer(550), Boolean.TRUE}, {new Integer(8), new Integer(-150), Boolean.TRUE}, {new Integer(9), new Integer(232)}, {new Integer(10), new Integer(734)}, {new Integer(11), new Integer(400), Boolean.TRUE}};
    private ChartPanel chartPanel;
    private XYSeries xySeries = new XYSeries((Comparable)((Object)"Some data"));
    private JCheckBox nullValuesCheckBox;
    private JCheckBox outlineCheckBox;
    private JTextField rangeBaseTextField;
    private JComboBox orientationComboBox;

    public XYStepAreaChartDemo(String string) {
        super(string);
        for (int i = 0; i < TEST_DATA.length; ++i) {
            this.xySeries.add((Integer)TEST_DATA[i][0], (Number)((Integer)TEST_DATA[i][1]));
        }
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(this.xySeries);
        JFreeChart jFreeChart = this.createChart(xYSeriesCollection);
        this.chartPanel = new ChartPanel(jFreeChart);
        this.chartPanel.setPreferredSize(new Dimension(500, 270));
        Plot plot = this.chartPanel.getChart().getPlot();
        plot.setOutlineStroke(new BasicStroke(2.0f));
        plot.setOutlinePaint(Color.magenta);
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        String[] stringArray = new String[]{ORIENT_VERT, ORIENT_HORIZ};
        this.orientationComboBox = new JComboBox<String>(stringArray);
        this.orientationComboBox.addActionListener(this);
        jPanel2.add(this.orientationComboBox);
        this.outlineCheckBox = new JCheckBox("Outline");
        this.outlineCheckBox.addActionListener(this);
        jPanel2.add(this.outlineCheckBox);
        jPanel2.add(new JLabel("Base"));
        this.rangeBaseTextField = new JTextField("0", 5);
        this.rangeBaseTextField.addActionListener(this);
        jPanel2.add(this.rangeBaseTextField);
        this.nullValuesCheckBox = new JCheckBox("NULL values");
        this.nullValuesCheckBox.addActionListener(this);
        jPanel2.add(this.nullValuesCheckBox);
        jPanel.add((Component)jPanel2, "South");
        jPanel.add(this.chartPanel);
        this.setContentPane(jPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYStepAreaChart("XY Step Area Chart Demo", "Domain (X)", "Range (Y)", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.getRenderer().setSeriesPaint(0, Color.green);
        XYStepAreaRenderer xYStepAreaRenderer = (XYStepAreaRenderer)xYPlot.getRenderer();
        xYStepAreaRenderer.setShapesFilled(true);
        return jFreeChart;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.nullValuesCheckBox) {
            boolean bl = this.nullValuesCheckBox.isSelected();
            for (int i = 0; i < TEST_DATA.length; ++i) {
                Integer n = (Integer)TEST_DATA[i][1];
                if (bl && TEST_DATA[i].length > 2) {
                    n = null;
                }
                this.xySeries.getDataItem(i).setY(n);
            }
        } else if (object == this.outlineCheckBox) {
            XYPlot xYPlot = (XYPlot)this.chartPanel.getChart().getPlot();
            ((XYStepAreaRenderer)xYPlot.getRenderer()).setOutline(this.outlineCheckBox.isSelected());
        } else if (object == this.rangeBaseTextField) {
            double d = Double.parseDouble(this.rangeBaseTextField.getText());
            XYPlot xYPlot = (XYPlot)this.chartPanel.getChart().getPlot();
            XYStepAreaRenderer xYStepAreaRenderer = (XYStepAreaRenderer)xYPlot.getRenderer();
            xYStepAreaRenderer.setRangeBase(d);
        } else if (object == this.orientationComboBox) {
            XYPlot xYPlot = (XYPlot)this.chartPanel.getChart().getPlot();
            if (this.orientationComboBox.getSelectedItem() == ORIENT_HORIZ) {
                xYPlot.setOrientation(PlotOrientation.HORIZONTAL);
            } else if (this.orientationComboBox.getSelectedItem() == ORIENT_VERT) {
                xYPlot.setOrientation(PlotOrientation.VERTICAL);
            }
        }
        this.chartPanel.repaint();
    }

    public static void main(String[] stringArray) {
        XYStepAreaChartDemo xYStepAreaChartDemo = new XYStepAreaChartDemo("Step Area XY Chart Demo");
        xYStepAreaChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(xYStepAreaChartDemo);
        xYStepAreaChartDemo.setVisible(true);
    }
}

