/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.IntervalXYDataset;
import org.jfree.data.xy.XYBarDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYBarChartDemo4
extends ApplicationFrame {
    public XYBarChartDemo4(String string) {
        super(string);
        IntervalXYDataset intervalXYDataset = this.createDataset();
        JFreeChart jFreeChart = ChartFactory.createXYBarChart(string, "X", false, "Y", intervalXYDataset, PlotOrientation.VERTICAL, true, false, false);
        jFreeChart.setBackgroundPaint(new GradientPaint(0.0f, 0.0f, Color.white, 1000.0f, 0.0f, Color.blue));
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        NumberAxis numberAxis = (NumberAxis)xYPlot.getDomainAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 300));
        this.setContentPane(chartPanel);
    }

    private IntervalXYDataset createDataset() {
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"));
        xYSeries.add(1.0, 5.0);
        xYSeries.add(2.0, 7.8);
        xYSeries.add(3.0, 9.3);
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection();
        xYSeriesCollection.addSeries(xYSeries);
        return new XYBarDataset(xYSeriesCollection, 0.9);
    }

    public static void main(String[] stringArray) {
        XYBarChartDemo4 xYBarChartDemo4 = new XYBarChartDemo4("XY Bar Chart Demo 4");
        xYBarChartDemo4.pack();
        RefineryUtilities.centerFrameOnScreen(xYBarChartDemo4);
        xYBarChartDemo4.setVisible(true);
    }
}

