/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.chart.demo;

import java.awt.Color;
import java.awt.Dimension;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class XYAreaChartDemo
extends ApplicationFrame {
    public XYAreaChartDemo(String string) {
        super(string);
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Random 1"));
        xYSeries.add(new Integer(1), (Number)new Double(500.2));
        xYSeries.add(new Integer(2), (Number)new Double(694.1));
        xYSeries.add(new Integer(3), (Number)new Double(-734.4));
        xYSeries.add(new Integer(4), (Number)new Double(453.2));
        xYSeries.add(new Integer(5), (Number)new Double(500.2));
        xYSeries.add(new Integer(6), (Number)new Double(300.7));
        xYSeries.add(new Integer(7), (Number)new Double(734.4));
        xYSeries.add(new Integer(8), (Number)new Double(453.2));
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Random 2"));
        xYSeries2.add(new Integer(1), (Number)new Double(700.2));
        xYSeries2.add(new Integer(2), (Number)new Double(534.1));
        xYSeries2.add(new Integer(3), (Number)new Double(323.4));
        xYSeries2.add(new Integer(4), (Number)new Double(125.2));
        xYSeries2.add(new Integer(5), (Number)new Double(653.2));
        xYSeries2.add(new Integer(6), (Number)new Double(432.7));
        xYSeries2.add(new Integer(7), (Number)new Double(564.4));
        xYSeries2.add(new Integer(8), (Number)new Double(322.2));
        XYSeriesCollection xYSeriesCollection = new XYSeriesCollection(xYSeries);
        xYSeriesCollection.addSeries(xYSeries2);
        JFreeChart jFreeChart = this.createChart(xYSeriesCollection);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private JFreeChart createChart(XYDataset xYDataset) {
        JFreeChart jFreeChart = ChartFactory.createXYAreaChart("XY Area Chart Demo", "Domain (X)", "Range (Y)", xYDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setForegroundAlpha(0.65f);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        ValueAxis valueAxis = xYPlot.getDomainAxis();
        valueAxis.setTickMarkPaint(Color.black);
        valueAxis.setLowerMargin(0.0);
        valueAxis.setUpperMargin(0.0);
        ValueAxis valueAxis2 = xYPlot.getRangeAxis();
        valueAxis2.setTickMarkPaint(Color.black);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        XYAreaChartDemo xYAreaChartDemo = new XYAreaChartDemo("XY Area Chart Demo");
        xYAreaChartDemo.pack();
        RefineryUtilities.centerFrameOnScreen(xYAreaChartDemo);
        xYAreaChartDemo.setVisible(true);
    }
}

